<?php

# Use UTF-8 encoding
Configure::write('App.encoding', 'UTF-8');

# Load all configurations
$configurations = glob(dirname(__FILE__) . '/*.conf.php');
foreach ($configurations as $configuration) {
	require_once $configuration;
}

# Load the Google client library
$googleClient = VECTORCMS_ROOT . 'Vendor' . DS . 'google-api-php-client-2.1.1/vendor/autoload.php';
if (is_readable($googleClient)) {
	require_once $googleClient;
}

# Load the default locale
if (defined('DEFAULT_LOCALE')) {
	Configure::write('Config.language', DEFAULT_LOCALE);
}

# Foundation
App::uses('Router', 'Routing');
App::uses('BaseUser', 'Model');
App::uses('CakeEmail', 'Network/Email');
App::uses('FrontController', 'Controller');
App::uses('AppFrontController', 'Controller');
App::uses('AppPluginController', 'Controller');
App::uses('AppBackendController', 'Controller');

# Prepare double environment
App::build([
	'Model'          => [ ROOT . DS . 'app' . DS . 'Model' . DS, VECTORCMS_ROOT . 'Model' . DS ],
	'Model/Behavior' => [ VECTORCMS_ROOT . 'Model' . DS . 'Behavior' . DS, ROOT . DS . 'app' . DS . 'Model' . DS . 'Behavior' . DS ],

	'View'          => [ VECTORCMS_ROOT . 'View' . DS, ROOT . DS . 'View' . DS ],
	'View/Helper'   => [ VECTORCMS_ROOT . 'View' . DS . 'Helper' . DS, ROOT . DS . 'View' . DS . 'Helper' . DS ],
	'View/Elements' => [ VECTORCMS_ROOT . 'View' . DS . 'Elements' . DS, ROOT . DS . 'View' . DS . 'Elements' . DS ],

	'Controller'           => [ VECTORCMS_ROOT . 'Controller' . DS, ROOT . 'app' . DS . 'Controller' . DS ],
	'Controller/Component' => [ VECTORCMS_ROOT . 'Controller' . DS . 'Component' . DS ],

	'Plugin' => [ VECTORCMS_ROOT . 'Plugin' . DS ],
	'Vendor' => [ VECTORCMS_ROOT . 'Vendor' . DS ],
	'Locale' => [ VECTORCMS_ROOT . 'Locale' . DS ],

	'Exception' => [ VECTORCMS_ROOT . 'Exception' . DS ],

	'Console/Command' => [ VECTORCMS_ROOT . 'Console' . DS . 'Command' . DS ],
	'Console/Handler' => [ APP . 'Console' . DS . 'Handler' . DS ]
]);

# Additional mimetypes for upload
$builder = \Mimey\MimeMappingBuilder::create();
$builder->add('text/x-php', 'php');

# Load VectorCMS routes
require_once VECTORCMS_ROOT . 'Config' . DS . 'routes.php';

# Load plugins
require ROOT . DS . 'app' . DS . 'Config' . DS . 'plugins.php';
CakePlugin::load('Seo');
CakePlugin::load('Newsletter', [ 'bootstrap' => true ]);
// FIXME CakePlugin::load('Cronner', [ 'bootstrap' => true ]);
CakePlugin::load('ModuleRelationships');
if (Configure::read('debug') >= 2) {
	CakePlugin::load('DebugKit');
}

# Dispatch filters
Configure::write('Dispatcher.filters', [
	'AssetDispatcher',
	'CacheDispatcher'
]);

# Default caching
Cache::config('default', [
	'engine' => CACHE_ENGINE,
	'prefix' => CACHE_PREFIX . 'default_'
]);
