<?php

# ~ VectorCMS definitions  - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('STRUCTURE_SKIP', 1);
define('STATIC_BASE_URL', '/');

# ~ Definitions of possible units of file sizes	 - - - - - - - - - - - - - - - #
define('B', 1);
define('KB', 1024);
define('MB', 1232896);
define('GB', 1262485504);
define('TB', 1292785156096);

# ~ HTTP methods - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('GET', 'GET');
define('PUT', 'PUT');
define('POST', 'POST');
define('DELETE', 'DELETE');

# ~ Shorthands - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('ASC', 'ASC');
define('DESC', 'DESC');

# ~ Common used regular expresions - - - - - - - - - - - - - - - - - - - - - - #
define('RFC_2822', '~^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+(?:[A-Z]{2}|com|org|net|edu|gov|mil|biz|info|mobi|name|aero|asia|jobs|museum)$~ i');
define('GPS_LOCATION', '~^ *\d+\.\d+ *, *\d+\.\d+ *$~ i');
define('YOUTUBE_CODE', '~(?<=(?:v|i)=)[a-zA-Z0-9-]+(?=&)|(?<=(?:v|i)\/)[^&\n]+|(?<=embed\/)[^"&\n]+|(?<=‌​(?:v|i)=)[^&\n]+|(?<=youtu.be\/)[^&\n]+~');

# ~ Prominent administrator groups - - - - - - - - - - - - - - - - - - - - - - #
define('GROUP_SUPERADMINS', 1);

# ~ Shorthands for routing - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('P', 'plugin');
define('C', 'controller');
define('A', 'action');

# ~ Cookie names - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('COOKIE_POLICY_ACCEPTED', 'cp');

# ~ Configuration  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('ON_FA_VALUE', 'fa fa-fw fa-check');
define('OFF_FA_VALUE', 'fa fa-fw fa-times');

# ~ List of requests type that should return plain text (not HTML) - - - - - - #
define('HTML_REQUEST', '~\b(application|text)/html\b~ i');

# ~ Commonly used  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
define('DATETIME', 'Y-m-d H:i:s');
