<?php
define('LOG_ERROR', LOG_ERR);

# Debug file log
CakeLog::config('debug', [
	'engine' => 'FileLog',
	'types'  => [ 'notice', 'info', 'debug' ],
	'file'   => 'debug',
]);

# Error file log
CakeLog::config('error', [
	'engine' => 'FileLog',
	'types'  => [ 'warning', 'error', 'critical', 'alert', 'emergency' ],
	'file'   => 'error',
]);

/**
 * Configure the Error handler used to handle errors for your application.    By default
 * ErrorHandler::handleError() is used.     It will display errors using Debugger, when debug >
 * 0 and log errors with CakeLog when debug = 0. Options:
 * - `handler` - callback - The callback to handle errors. You can set this to any callback
 * type, including anonymous functions.
 * - `level` - int - The level of errors you are interested in capturing.
 * - `trace` - boolean - Include stack traces for errors in log files.
 *
 * @see ErrorHandler for more information on error handling and configuration.
 */
Configure::write('Error', [
	'handler' => 'ErrorHandler::handleError',
	'level'   => E_ALL & ~E_DEPRECATED & ~E_STRICT,
	'trace'   => true
]);

/**
 * Configure the Exception handler used for uncaught exceptions.  By default,
 * ErrorHandler::handleException() is used. It will display a HTML page for the exception, and
 * while debug > 0, framework errors like Missing Controller will be displayed.     When debug
 * = 0, framework errors will be coerced into generic HTTP errors. Options:
 * - `handler` - callback - The callback to handle exceptions. You can set this to any callback
 * type, including anonymous functions.
 * - `renderer` - string - The class responsible for rendering uncaught exceptions.     If you
 * choose a custom class you should place the file for that class in app/Lib/Error. This class
 * needs to implement a render method.
 * - `log` - boolean - Should Exceptions be logged?
 *
 * @see ErrorHandler for more information on exception handling and configuration.
 */
Configure::write('Exception', [
	'handler'  => 'ErrorHandler::handleException',
	'renderer' => 'ExceptionRenderer',
	'log'      => true
]);
