<?php
$plugins = [];

# Sitemap
Router::connect('/sitemap.xml', [ P => 'seo', C => 'sitemap', A => 'sitemap' ]);

# Application specific routing
require_once ROOT . DS . 'app' . DS . 'Config' . DS . 'routes.php';

# Routing for backend
if (CMS) {

	# Define available plugins
	$plugins['cronner'] = 'cronnerDashboard';

	# Setup plugins
	foreach ($plugins as $prefix => $defaultController) {
		Router::connect('/' . $prefix . '/:controller/add/*', [ P => $prefix, A => 'form' ]);
		Router::connect('/' . $prefix . '/:controller/edit/*', [ P => $prefix, A => 'form' ]);
		Router::connect('/' . $prefix . '/:controller/:action/*', [ P => $prefix ]);
		Router::connect('/' . $prefix . '/:controller/*', [ P => $prefix ]);
		Router::connect('/' . $prefix . '/*', [ P => $prefix, C => $defaultController ]);
		Router::connect('/' . $prefix . '/', [ P => $prefix, C => $defaultController ]);
	}

	# CLI routes
	if (isCLI()) {
		Router::connect('/crons/:action/*', [ C => 'crons' ]);
	}

	# Root routes
	Router::connect('/', [ C => 'administrators', A => 'login' ]);
	Router::connect('/_moduleconnections/:action/*', [ C => 'moduleconnections' ]);

	# Newsletter routing
	Router::connect('/newsletter/', [ P => 'newsletter', C => 'lists' ]);
	Router::connect('/newsletter/:controller', [ P => 'newsletter', A => 'index' ]);
	Router::connect('/newsletter/:controller/add/*', [ P => 'newsletter', A => 'form' ]);
	Router::connect('/newsletter/:controller/edit/*', [ P => 'newsletter', A => 'form' ]);
	Router::connect('/newsletter/:controller/reset', [ P => 'newsletter', A => 'filter' ]);
	Router::connect('/newsletter/:controller/:all/*', [ P => 'newsletter', A => 'index' ], [ 'all' => 'all', 'pass' => [ 'all' ] ]);
	Router::connect('/newsletter/:controller/:copy/:id', [ P => 'newsletter', A => 'form' ], [ 'id' => '[0-9]+', 'copy' => 'copy', 'pass' => [ 'id', 'copy' ] ]);
	Router::connect('/newsletter/:controller/:action/*', [ P => 'newsletter' ]);
	Router::connect('/:module/newsletter/:action/*', [ P => 'newsletter', C => 'main' ]);

	# Categories
	Router::connect('/:ctrl/categories', [ C => 'categories', A => 'index' ]);
	Router::connect('/:ctrl/categories/add/*', [ C => 'categories', A => 'form' ]);
	Router::connect('/:ctrl/categories/edit/*', [ C => 'categories', A => 'form' ]);
	Router::connect('/:ctrl/categories/reset', [ C => 'categories', A => 'filter' ]);
	Router::connect('/:ctrl/categories/:copy/:id', [ C => 'categories', A => 'form' ], [ 'id' => '[0-9]+', 'copy' => 'copy', 'pass' => [ 'id', 'copy' ] ]);
	Router::connect('/:ctrl/categories/:action/*', [ C => 'categories' ]);

	# Comments
	Router::connect('/:ctrl/comments', [ C => 'comments', A => 'index' ]);
	Router::connect('/:ctrl/comments/add/*', [ C => 'comments', A => 'form' ]);
	Router::connect('/:ctrl/comments/edit/*', [ C => 'comments', A => 'form' ]);
	Router::connect('/:ctrl/comments/reset', [ C => 'comments', A => 'filter' ]);
	Router::connect('/:ctrl/comments/:copy/:id', [ C => 'comments', A => 'form' ], [ 'id' => '[0-9]+', 'copy' => 'copy', 'pass' => [ 'id', 'copy' ] ]);
	Router::connect('/:ctrl/comments/:action/*', [ C => 'comments' ]);

	# Administration
	Router::connect('/login', [ C => 'administrators', A => 'login' ]);
	Router::connect('/logout', [ C => 'administrators', A => 'logout' ]);
	Router::connect('/recovery', [ C => 'administrators', A => 'recovery' ]);
	Router::connect('/customize/*', [ C => 'administrators', A => 'customize' ]);
	Router::connect('/my_profile/*', [ C => 'administrators', A => 'profile' ]);

	# API testing
	Router::connect('/wd', [ P => 'WatchDog', C => 'watch_dog' ]);
	Router::connect('/wd/endpoint/:method/*', [ P => 'WatchDog', C => 'endpoint', A => 'router' ]);
	Router::connect('/wd/:action', [ P => 'WatchDog', C => 'watch_dog' ]);
	Router::connect('/wd/:controller/:action', [ P => 'WatchDog' ]);

	# Tools
	Router::connect('/aco/*', [ C => 'tools', A => 'aco' ]);
	Router::connect('/dump/*', [ C => 'tools', A => 'dump' ]);
	Router::connect('/clear/*', [ C => 'tools', A => 'clear' ]);
	Router::connect('/image/*', [ C => 'tools', A => 'image' ]);
	Router::connect('/phpinfo/*', [ C => 'tools', A => 'phpinfo' ]);
	if (defined('SECURITY_PMA_TOKEN')) {
		Router::connect('/phpMyAdmin-' . SECURITY_PMA_TOKEN . '/*', [ C => 'tools', A => 'phpMyAdmin' ]);
	}

	# Module relationships
	Router::connect('/module-relationships/*', [ P => 'ModuleRelationships', C => 'search', A => 'index' ]);

	# Controller defaults
	Router::connect('/:controller', [ A => 'index' ]);
	Router::connect('/:controller/add/*', [ A => 'form' ]);
	Router::connect('/:controller/edit/*', [ A => 'form' ]);
	Router::connect('/:controller/reset', [ A => 'filter' ]);
	Router::connect('/:controller/:all/*', [ A => 'index' ], [ 'all' => 'all', 'pass' => [ 'all' ] ]);
	Router::connect('/:controller/:copy/:id', [ A => 'form' ], [ 'id' => '[0-9]+', 'copy' => 'copy', 'pass' => [ 'id', 'copy' ] ]);
	Router::connect('/:controller/:action/*', [ A => 'index' ]);

	# Routing for front
} else {

	# Upload
	Router::connect('/upload', [ P => null, C => 'upload', A => 'index' ]);
	Router::connect('/upload/preview', [ P => null, C => 'upload', A => 'preview' ]);
	Router::connect('/upload/preview/*', [ P => null, C => 'upload', A => 'preview' ]);

	# CMS features
	Router::connect('/carts/:action', [ C => 'carts' ]);
	Router::connect('/comments/:action', [ C => 'comments' ]);
	Router::connect('/moduleconnections/:action', [ C => 'moduleconnections' ]);

	# Everything else redirect to front
	Router::connect('/*', [ C => 'front', A => 'index' ]);
}

# Handle language routing
if (INSTALLED) {

	# Get all languages
	$languages = Cache::read('languages');
	if ($languages === false) {
		App::uses('AppModel', 'Model');
		App::uses('Language', 'Model');
		$Language = new Language();
		$languages = $Language->find('list', [ 'fields' => [ 'locale', 'title' ], 'conditions' => [ 'Language.is_active' => true ] ]);
		Cache::write('languages', $languages);
	}

	# Apply language routing
	$routes = array_reverse(Router::$routes);
	foreach ($routes as $route) {
		$condition = [ 'language' => implode('|', array_keys($languages)) ];
		Router::connect(
			'/:language' . rtrim($route->template, '/'),
			$route->defaults,
			Set::merge($route->options, $condition)
		);
		Router::promote();
	}
}
