#!/usr/bin/php
<?php

# Define collors
$_white = "\e[0m ";
$_green = "\e[32m ";
$_blue = "\e[34m ";
$_red = "\e[31m ";

# Notify user
echo 'LISTENING' . PHP_EOL;

# Capture
$stdin = fopen('php://stdin', 'r');
while (!feof($stdin)) {
	$line = rtrim(fgets($stdin), "\r\n");

	# Capture error
	if (preg_match('~^(?<y>\d\d\d\d)-(?<m>\d\d)-(?<d>\d\d) (?<h>\d\d):(?<i>\d\d):(?<s>\d\d) (?<error>.+)$~', $line, $match)) {
		echo PHP_EOL . PHP_EOL . "{$_red}{$match['error']}{$_white}" . PHP_EOL;
		continue;
	}

	# Nothing
	echo "\t{$line}" . PHP_EOL;
}

echo "DONE";

# Clean up
fclose($stdin);
