<?php

class CartsController extends AppBackendController {

	public $cartInstance;

	function beforeFilter() {
		$this->Auth->allow();
		parent::beforeFilter();

		$this->cartInstance = ClassRegistry::init("ShoppingCart");
	}

	public function clearSession() {
		CakeSession::delete('cart');
		CakeSession::delete('order');
		CakeSession::delete('user');
	}

	# Get items from shopping cart.
	public function get() {
		$response = [];
		if (CakeSession::check('order')) {
			$response['data'] = CakeSession::read('order');
			$response['status'] = "OK";
		}
		echo json_encode($response);
		exit;
	}

	# Add item to shopping cart.
	public function add() {
		$data = $this->request->data;
		$response = '';

		if (empty($data['extras']))
			$data['extras'] = [];

		$modelData = $this->cartInstance->add($data);

		if ($modelData === true) {
			$response = [ 'status' => 'OK' ];
			$response['added'] = $data;
		} else {
			$response = [ 'status' => 'ERROR' ];
			if (is_array($modelData)) {
				$response['errors'] = $modelData;
			}
		}

		$response['data'] = CakeSession::read('order');
		echo json_encode($response);
		exit;
	}

	# Remove item from shopping cart.
	public function delete() {
		$data = $this->request->data;
		$response = '';

		$modelData = $this->cartInstance->delete($data);

		if ($modelData === true) {
			$response = [ 'status' => 'OK' ];
			$response['deleted'] = $data;
		} else {
			$response = [ 'status' => 'ERROR' ];
			if (is_array($modelData)) {
				$response['errors'] = $modelData;
			}
		}

		$response['data'] = CakeSession::read('order');
		echo json_encode($response);
		exit;
	}

	# Check item status in shopping cart.
	public function check() {
		$data = $this->request->data;
		$searchResults = $this->cartInstance->check($data);

		if (empty($searchResults)) {
			echo json_encode([ 'status' => 'OK', 'data' => [] ]);
			exit;
		}

		$response['data'] = reset($searchResults);
		$response['status'] = 'OK';

		echo json_encode($response);
		exit;
	}

	# Edit shopping cart item.
	public function edit() {
		$data = $this->request->data;
		$response = '';

		$modelData = $this->cartInstance->edit($data);

		if ($modelData === true) {
			$response = [ 'status' => 'OK' ];
			$response['changed'] = $data;
		} else {
			$response = [ 'status' => 'ERROR' ];
			if (is_array($modelData)) {
				$response['errors'] = $modelData;
			}
		}

		$response['data'] = CakeSession::read('order');
		echo json_encode($response);
		exit;
	}

	# Add header to shopping cart contents, like info about user.
	public function setHeader() {
		$response = '';

		if ($this->cartInstance->setHeader($this->request->data)) {
			$response = [ 'status' => 'OK' ];
		} else {
			$response = [ 'status' => 'ERROR' ];
		}

		$response['data'] = CakeSession::read('order');
		echo json_encode($response);
		exit;
	}

	# Commit purchase.
	public function commit() {
		if (!CakeSession::check('order')) {
			return false;
		}
		$response = '';
		if ($this->cartInstance->commit()) {
			$response = [ 'status' => 'OK' ];
		} else {
			$response = [ 'status' => 'ERROR' ];
		}

		$response['data'] = CakeSession::read('order');
		# Send email
		$sent = $this->sendEmail('Narudzbina na Kockicama', $response['data'])
			->template('order')
			->emailFormat('html')
			->to(CakeSession::read('user.User.email'))
			//->addBcc('sabo@intellex.rs')
			->from('gateway@intellex.rs', 'Kockice')
			->send();

		CakeSession::delete('order');
		echo json_encode($response);
		exit;
	}

}

