<?php

class PagesController extends AppBackendController {

	var $name = 'Pages';
	var $back = [ 'error', 'module' ];
	var $paginate = [];

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('types', [
			Page::TYPE_PAGE    => 'Page',
			Page::TYPE_WRAPPER => 'Wrapper',
			Page::TYPE_LINK    => 'Link'
		]);
	}

	function beforeIndex() {
		$this->paginate['Page']['conditions'][] = [ 'Page.id <>' => 1, 'Page.type <>' => 'Module' ];
		$this->addAction('crop', __('Edit 404 page'), [ C => $this->name, A => 'error' ]);
	}

	function beforeForm() {

		# After saving the template for module
		if (!empty($this->request->data['Page']['module_id'])) {
			$module = ClassRegistry::init('Module')->field('name', [ 'id' => $this->request->data['Page']['module_id'] ]);

			if (!empty($module)) {

				# Set the parent page to be the master of the module
				if (!empty($this->request->data['Page']['parent_id'])) {
					$this->Page->save([
						'id'        => $this->request->data['Page']['parent_id'],
						'module_id' => $this->request->data['Page']['module_id']
					]);
				}

				# Rediret to module after editing module template
				$this->redirect = [ C => Inflector::tableize($module) ];
			}
		}
	}

	# ~ Just before the rendering of the form  - - - - - - - - - - - - - - - - - - #
	function afterForm() {

		# Setup the blocks for editing
		if (!empty($this->request->data['Page']['id'])) {
			$this->request->data['Content'] = $this->Content->getContent('Page', $this->request->data['Page']['id'], 'content');
		} else {
			if (isset($this->request->params['named']['parent_id'])) {
				$parentIsCategory = $this->Page->field('is_category', [ 'Page.id' => $this->request->params['named']['parent_id'] ]);
				if ($parentIsCategory) {
					$this->request->data['Page']['is_category'] = true;
				}
			}
		}
	}

	# ~ Edit the error page	 - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	function error() {
		$this->setAction('form', 1);
		$this->afterForm();
		$this->render('/Pages/form');
	}

	# ~ Editing details page for CMS module	 - - - - - - - - - - - - - - - - - - - #
	function module($moduleName = null) {

		# Read the module
		$module = $this->Page->Module->findByName($moduleName, 'id');
		if (!$module) {
			$this->redirect($this->referer());
		}

		# Get existing page for this module
		$page = $this->Page->find(
			'first',
			[
				'full'       => true,
				'conditions' => [
					'Page.type'   => 'Module',
					'Module.name' => $moduleName ] ]
		);
		$this->request->data = $page ? $page : $this->Page->create([
			'type'      => 'Module',
			'module_id' => $module['Module']['id']
		]);

		# Get all layouts
		$this->set('layouts', $this->Layout->find('list'));

		# Allow showing module_id fields in form
		// TODO: Može ovo bolje, sigurno...
		$index = array_search('module_id', $this->{$this->modelClass}->invisible);
		unset($this->{$this->modelClass}->invisible[$index]);
		$index = array_search('module_id', $this->{$this->modelClass}->locked);
		unset($this->{$this->modelClass}->locked[$index]);
		$fieldOptions['module_id'] = [ 'type' => 'hidden', 'value' => $module['Module']['id'] ];
		$this->set('fieldOptions', $fieldOptions);

		$this->afterForm();
		$this->render('/Pages/form');
	}

	# ~ Get template by id - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function template($id, $field, $locale, $i) {
		$this->Template->recursive = -1;
		$this->Template->data = $this->Template->find('first', $id);
		$this->Template->insertBlocks();
		$template = $this->Template->data;

		# Init empty content and blocks
		$template['Content'] = [ 'id' => null, 'template_id' => $id ];
		foreach ($template['Template']['fields'] as $name => $type) {
			$template['Blocks'][$name] = [ 'name' => $name, 'type' => $type, 'content' => '' ];
		}

		# Set language
		$languages = Configure::read('Config.Languages');
		$language = $languages[$locale];

		# Paste variables to view
		$this->set(compact('language', 'template', 'field', 'i'));
	}

	# ~ Get page url and redirect to page  - - - - - - - - - - - - - - - - - - - - #
	public function show($id) {
		$pageType = $this->Page->field('type', [
			'Page.id' => $id
		]);

		# Get the propery ULR
		$pageType == 'Page'
			? $this->redirect(FRONT_BASE_URL . $this->Page->getPageLink($id))
			: $this->redirect('/pages/edit/' . $id);
	}

}
