<?php
class Bookmark extends AppModel {

	public $invisible = [ 'administrator_id', 'ordering', 'modified', 'modified_by', 'created', 'created_by' ];

	public $locked = [ 'url' ];

	function initValidation() {

		return array(
			'name' => array(
				array(
					'rule' => 'notBlank',
					'required' => true,
					'message' => __('Please enter the name of the bookmark'))),

			'url' => array(
				array(
					'rule' => 'notBlank',
					'required' => true,
					'message' => __('Please enter the target URL for the bookmark')))
		);
	}

}
