<?php

	define('SUCCESS_MESSAGE', __('Vaš komentar je sačuvan. U narednih 24h biće pregledan od strane administratora.'));
	define('FAIL_MESSAGE', __('Vaš komentar nije sačuvan, molimo pokušajte kasnije'));


	App::uses('BaseComment', 'Model');
	class Comment extends BaseComment {

		var $useTable = 'comments';
		var $order = "Comment.created DESC";
		var $actsAs = array('Tree');

		var $successMessage = SUCCESS_MESSAGE;
		var $failMessage = FAIL_MESSAGE;

		var $userFields = array('name', 'text');

		public $validate = array(
			'name' => array(
				'notBlank' => array(
					'rule' => array('notempty'),
					'required' => true,
					'message' => 'Molimo unesite ime' )),
			'text' => array(
				'notBlank' => array(
					'rule' => array('notempty'),
					'required' => true,
					'message' => 'Molimo unesite tekst' ))

		);
	}
