<?php
class Element extends AppModel {

	public $tablePrefix = 'live_';

	public $formOptions = array(
		'data' => array(
			'rte' => false,
			'class' => 'cm-full',
			'style' => 'height:600px;font-family:Monospace,Courier New'
		)
	);

	public $actsAs = array(
		'Live' => array(
			'field' => 'body',
			'folder' => 'View/Elements',
			'extension' => 'ctp')
	);


# ~ beforeValidate - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	function beforeValidate($options = array()) {

		# Validate and properly pack arguments
		if(isset($this->data[$this->alias]['arguments'])) {
			$arguments = $this->data[$this->alias]['arguments'];
			$arguments = trim(preg_replace('~\s*,\s*~', ', ', $arguments));

			# Validate
			if(!preg_match('~^([a-z]+(,\s*)?)*$~ i', $arguments)) {
				$this->invalidate('arguments', __('Only letters allowed for argument name. Use commas to separate them.'));
				return false;
			}

			$this->data[$this->alias]['arguments'] = $arguments;
		}

		return true;
	}

}
