<?php
class SeoConfig extends AppModel {
	public $useTable = 'seo_configuration';
	public $isSingleItem = true;
	public $isModule = true;

	public $_invisible = array('seo_metatags');

	public $actsAs = array('Seo.MetaTagged');

	var $hasOne = array(
		'GlobalMetaImage' => 'Upload jpeg jpg png gif'
	);

	public function initTabs() {
		return array(
			__('Meta Tags') => 'form/meta/meta_config',
			__('Custom Code') => 'form/meta/additional_code'
		);
	}


# ~ Extract main tags from data- - - - - - - - - - - - - - - - - - - - - - - - #
	public function extractMainTags($data, $request = null) {
		$mainTags = array(
			'title' => '',
			'url' => FULL_BASE_URL . ($request ? $request->here : ''),
			'description' => '',
			'keywords' => '',
			'image' => ''
		);

		# If empty data
		if(empty($data)) {
			return $mainTags;
		}

		# Get global tags
		$mainTags['title'] = $data[$this->alias]['global_meta_title'];
		$mainTags['description'] = $data[$this->alias]['global_meta_description'];
		$mainTags['keywords'] = $data[$this->alias]['global_meta_keywords'];
		$mainTags['image'] = $data['GlobalMetaImage']['file'];

		return $mainTags;
	}


# ~ Extract additional metatags- - - - - - - - - - - - - - - - - - - - - - - - #
	public function extractAdditionalTags($data, $metatags, $mainTags, $locale = null) {

		// !!TODO: Extract additional tags and merge with main tags
	}


	public function getGlobalMetaTags() {
		$item = $this->find('first');
		if(!isset($item['Seo']['metatag'])) return array();
		return $item['Seo']['metatag'];
	}

}
