<?php if(!$mainJobExists) { ?>
<div class="row-fluid">
	<div class="col-sm-12 alert-danger text-center" style="padding: 10px;">
		<p><?= __('In order for defined cron jobs to work, system administrator must add following cron job to crontab:') ?></p>
		<p><pre style="font-family:courier 'courier new', courier; font-weight: bold;"><?= $mainJob ?></pre></p>
	</div>
</div>
<?php } ?>

<div class="row-fluid small-boxes">

	<div class="col-lg-3 col-xs-6">
		<div class="small-box">
			<div class="inner">
				<h3><?= count($jobs) ?></h3>
				<p><?= __('Defined Jobs') ?></p>
			</div>
			<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'add')) ?>" class="small-box-footer"><?= __('Create New Job') ?> <i class="fa fa-arrow-circle-right"></i></a>
		</div>
	</div>

	<div class="col-lg-3 col-xs-6">
		<div class="small-box">
			<div class="inner">
				<h3><?= count($handlers) ?></h3>
				<p><?= __('Defined Handlers') ?></p>
			</div>
			<a href="javascript:void(0)" data-toggle="modal" data-target="#howToCreateModal" class="small-box-footer"><?= __('How to create Handler') ?> <i class="fa fa-arrow-circle-right"></i></a>
		</div>
	</div>

	<div class="col-lg-3 col-xs-6">
		<div class="small-box">
			<div class="inner">
				<h3><?= $totalRuns ?></h3>
				<p><?= __('Number of runs') ?></p>
			</div>
		</div>
	</div>

	<div class="col-lg-3 col-xs-6">
		<div class="small-box">
			<div class="inner">
				<h3><?= $totalFailedRuns ?></h3>
				<p><?= __('Failed runs') ?></p>
			</div>
		</div>
	</div>
</div>
<div class="clear"></div>

<div class="index row-fluid">

	<div class="col-sm-6">
		<div class="block">
			<h2>
				<span>
					<i class="fa-fw fa-code" style="font-size: 20px"></i>
					<?=	 __('Jobs') ?>
				</span>
				<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'add')) ?>" class="btn btn-danger pull-right"><i class="fa fa-plus"></i><?= __('Create New') ?></a>
				<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'index')) ?>" class="btn btn-danger pull-right"><i class="fa fa-list"></i><?= __('List All') ?></a>
			</h2>
			<table>
				<tbody>
					<tr>
						<th><?= __('Name') ?></th>
						<th><?= __('Description') ?></th>
						<th><?= __('Created') ?></th>
						<th></th>
					</tr>
					<?php foreach($jobs as $failedRun) { ?>
						<tr>
							<td width="200">
								<?= $this->Html->link($failedRun['CronJob']['name'], array(P => 'Cronner', C => 'cronJobs', A => 'view', $failedRun['CronJob']['id'])) ?>
							</td>
							<td class="action-green" width="*">
								<?= $failedRun['CronJob']['description'] ?>
							</td>
							<td width="160" align="center">
								<?= date('d. M Y. / H', strtotime($failedRun['CronJob']['created'])) ?>
							</td>
							<td width="160" align="center" style="text-align: center;">
								<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'edit', $failedRun['CronJob']['id'])) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-pencil button"></i></a>
								<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'view', $failedRun['CronJob']['id'])) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-eye button"></i></a>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="col-sm-6">
		<div class="block">
			<h2>
				<span>
					<i class="fa-fw fa-exclamation-circle" style="font-size: 20px"></i>
					<?=	 __('Failing jobs') ?>
				</span>
			</h2>
			<table>
				<tbody>
				<?php if(empty($lastFailedRuns)) { ?>
					<tr>
						<td colspan="4"><?= __('No failed runs') ?></td>
					</tr>
				<?php } else { ?>
					<tr>
						<th><?= __('Job Name') ?></th>
						<th><?= __('Failed') ?></th>
						<th></th>
					</tr>
					<?php foreach($lastFailedRuns as $failedRun) { ?>
						<tr>
							<td width="200">
								<?= $this->Html->link($failedRun['CronJob']['name'], array(P => 'Cronner', C => 'cronJobs', A => 'view', $failedRun['CronJob']['id'])) ?>
							</td>
							<td width="160" align="center">
								<?= date('d. M Y. / H', strtotime($failedRun['CronJob']['created'])) ?>
							</td>
							<td width="160" align="center" style="text-align: center;">
								<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'edit', $failedRun['CronJob']['id'])) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-pencil button"></i></a>
								<a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'view', $failedRun['CronJob']['id'])) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-eye button"></i></a>
							</td>
						</tr>
					<?php } ?>
				<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
</div>

<div id="howToCreateModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">×</span>
				</button>
				<h4 class="h3 modal-title" id="myModalLabel"><?= __('How to create Handler') ?></h4>
			</div>
			<div class="modal-body">
				<h5 class="h4"><?= __('What is handler?') ?></h5>
				<p><?= __('Handler is class which defines the logic that should be executed in specific time.') ?></p>
				<p><?= __('You can define custom handlers in "%s"', '<strong>' . APP . 'Console' . DS . 'Handler' . '</strong>') ?></p>

				<br/>

				<h5 class="h4"><?= __('How to implement handler?') ?></h5>
				<p><?= __('Main function in handler is <strong>execute()</strong> function. Each handler must implement this function. When cron job is triggered, this function will be called.') ?></p>
				<p><?= __('Each handler must extend <strong>BaseHandler</strong> class, directly or through <strong>AppCronHandler</strong> class.') ?></p>
				<p><?= __('<strong>Note:</strong> If <strong>execute()</strong> function return false, or throw uncaught exception - job will be marked as failed.') ?></p>

				<br/>

				<h5 class="h4"><?= __('How to run cron job?') ?></h5>
				<p>1. <?= __('Create handler which will store logic in <strong>execute()</strong> function') ?></p>
				<p>2. <?= __('Create new cron job with desired expression and new handler') ?></p>
				<br/>
				<p><?= __('Global cron job is running each minute and checks expressions of all saved jobs in database. If some expression is matched, system executes <strong>execute()</strong> method of handler attached to that cron job.') ?></p>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>

<style>
	.padded {
		padding: 10px;
	}
	.small-boxes {
		margin-top: 10px;
	}
	.small-box {
		width: 100%;
		background: #3C9749;
		color: white;
	}
	.small-box .inner {
		padding: 10px;
	}
	.small-box h3 {
		font-size: 2em;
		margin-bottom: 20px;
	}
	.small-box .small-box-footer {
		background: rgba(255, 255, 255, 0.2);
		display: block;
		text-align: center;
		color: white;
	}
	.small-box .small-box-footer i {
		margin-left: 5px;
	}
</style>

<script>
	$(document).read
</script>
