<?php

/**
 * @var string  $module       The module for which this relationship is being edited.
 * @var string  $relationship The name of the relationship to use.
 * @var array[] $records      The records to initially show.
 * @var array   $options      The options to use.
 */

?>
<script>
	postExecute(function () {
		window.reform = new RelationshipForm(<?= json_encode($module) ?>, <?= json_encode($relationship) ?>, <?= json_encode(array_values($records)) ?>, <?= json_encode($options) ?>);
	});
</script>

<div class="relationship-form" id="<?= $module ?>-Relationship-<?= $relationship ?>">

	<div id="<?= Inflector::camelize($relationship) ?>RelationshipDialog-Add" style="display:none">
		<div class="relationship-form-dialog-header">
			<div class="block">
				<h2><?= humanize($relationship, true) ?></h2>
			</div>
			<div class="row">
				<div class="col-sm-11">
					<div class="relationship-form-dialog-filter row"></div>
				</div>
				<div class="col-sm-1">
					<a class="relationship-form-dialog-reset" href="javascript:void(0)">
						<i class="fa fa-fw fa-times"></i>
						<?= __('Reset') ?>
					</a>
				</div>
			</div>
		</div>

		<div class="relationship-form-dialog-body">
			<div class="relationship-form-dialog-list row" style="display: none;"></div>

			<div class="relationship-form-dialog-empty" style="display: none;">
				<?= __('There are no records to show.') ?>
			</div>

			<div class="relationship-form-dialog-loading">
				<img src="/img/ico/loader_medium.gif" alt="Loading..." />
				<?= __('Loading results, please wait...') ?>
			</div>
		</div>

		<div class="relationship-form-dialog-footer">
			<div class="relationship-form-dialog-pagination row" style="display: none;">
				<div class="page-paginator">
					<div class="paginator">

					</div>
				</div>
			</div>

			<div class="relationship-form-dialog-button row" style="display: none;">
				<div class="col-xs-12 text-center">
					<button class="btn btn-primary btn-center" onclick="nxDialog.hide();">
						<i class="fa fa-fw fa-check"></i>
						<?= __('Close') ?>
					</button>
				</div>
			</div>
		</div>
	</div>

	<a class="btn btn-primary nxDialogTrigger" href="#<?= Inflector::camelize($relationship) ?>RelationshipDialog-Add">
		<i class="fa fa-plus"></i>
		<?= __('Add ' . humanize($relationship)) ?>
	</a>

	<div class="relationship-form-selected-list row"></div>

</div>

