<?php namespace Newsletter\Builder\RequiredVar;

class ModuleRequiredVar extends RequiredVar {

	/**
	 * Parse the value to a template value.
	 *
	 * @param mixed $input The original value.
	 *
	 * @return mixed The parsed value, which will be sent to the template.
	 */
	function parse($input) {

		// Convert string to an array of one element
		$input = (array) $input;

		// Get the data from the database
		foreach ((array) $input as $i => $id) {
			$input[$i] = $this->getModule()->find('first', (int) $id);
		}

		return $input;
	}

	/** @return String The type of the required var. */
	function getType() {
		return static::MODULE;
	}

	/**
	 * Initialize the module.
	 *
	 * @return object The module used.
	 */
	public function getModule() {
		return \ClassRegistry::init($this->options['module']);
	}

	/**
	 * Initialize the module.
	 *
	 * @return object The module used.
	 */
	public function getModuleName() {
		return $this->options['module'];
	}

	/**
	 * Initialize the module.
	 *
	 * @return mixed The module used.
	 */
	public function getConditions() {
		return isset($this->options['conditions'])
			? $this->options['conditions']
			: [];
	}

	/**
	 * Get the required number of items..
	 *
	 * @return int The number of items.
	 */
	public function getCount() {
		return isset($this->options['count'])
			? $this->options['count']
			: 1;
	}

}