<?php
/**
 * @var \Intellex\MailChimp\Resource\ResourceSubscriber[] $subscribers
 * @var string                                            $controller
 * @var mixed                                             $_actions
 */

use Intellex\MailChimp\Enum\MergeFields;

// The options for the status
$statusOptions = [
	'subscribed'   => [ 'check', '#3fa04d' ],
	'unsubscribed' => [ 'times', '#bbaaaa' ],
	'cleaned'      => [ 'ban', '#bbaaaa' ],
	'pending'      => [ 'question', '#bbaaaa' ]
];

?>
<div class="main-content">
	<div class="header">
		<?= $this->Format->actions($_actions) ?>
	</div>
	<div class="index">
		<?= $this->Element('index/paginator', [ 'total' => $subscribers['total_items'] ]) ?>

		<table cellpadding="0" cellspacing="0" class="main-table-index">
			<thead>
			<tr class="">
				<th class="title">Email</th>
				<th class="char">First Name</th>
				<th class="char">Last Name</th>
				<th class="char">Status</th>
				<th class="actions">Actions</th>
			</tr>
			</thead>

			<tbody>
			<?php foreach ($subscribers['members'] as $subscriber) { ?>
				<tr>
					<td class="title"><a href="<?= Router::url([ P => 'newsletter', C => 'subscribers', A => 'details', $this->request['pass'][0], $subscriber->email ]) ?>"><?= $subscriber->email ?></a></td>
					<td class="char"><?= $subscriber->fields[MergeFields::FNAME] ?></td>
					<td class="char"><?= $subscriber->fields[MergeFields::LNAME] ?></td>
					<td class="bool">
						<i
							class="fa fa-<?= $statusOptions[$subscriber->status][0] ?>"
							style="color: <?= $statusOptions[$subscriber->status][1] ?>;"
							title="<?= $subscriber->status ?>">
						</i>
					</td>

					<td class="actions">
						<div class="actions">
							<ul class="actions narrow-actions">
								<li>
									<a href="<?= Router::url([ P => 'newsletter', C => 'subscribers', A => 'details', $this->request['pass'][0], $subscriber->email ]) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-pencil button"></i></a>
								</li>
							</ul>
						</div>
						<div class="clear"></div>
					</td>
				</tr>
			<?php } ?>
			</tbody>
		</table>
	</div>
</div>