<?php
/**
 * @var \Intellex\MailChimp\Resource\ResourceList[] $lists
 * @var string                                      $controller
 * @var mixed                                       $_actions
 */
?>
<div class="main-content">
	<div class="header">
		<?= $this->Format->actions($_actions) ?>
	</div>
	<div>
		<div class="index">
			<?= $this->Element('index/paginator', [ 'total' => $lists['total_items'] ]) ?>
			<table cellpadding="0" cellspacing="0" class="main-table-index">
				<thead>
				<tr class="">
					<th class="title">id</th>
					<th class="title">title</th>
					<th class="actions">Actions</th>
				</tr>
				</thead>

				<tbody>
				<?php foreach ($lists['lists'] as $list) { ?>
					<tr>
						<td class="actions"><?= $list->id ?></td>
						<td class="title"><a href="<?= Router::url([ P => 'newsletter', C => 'lists', A => 'details', $list->id ]) ?>"><?= $list->name ?></a></td>

						<td class="actions">
							<div class="actions">
								<ul class="actions narrow-actions">
									<li>
										<a href="<?= Router::url([ P => 'newsletter', C => 'lists', A => 'details', $list->id ]) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-pencil button"></i></a>
									</li>
									<li>
										<a href="<?= Router::url([ P => 'newsletter', C => 'lists', A => 'remove', $list->id ]) ?>" class="btn btn-danger btn-sm btn-icon-only" onclick="if (confirm(&quot;Are you sure you want to delete: <?= $list->name ?> ?&quot;)) { return true; } return false;"><i class="fa fa-fw fa-trash-o button"></i></a>
									</li>
								</ul>
							</div>
							<div class="clear"></div>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
</div>