<?php
App::uses('SeoGenerator', 'Seo.Model/MetaGenerators');

class SeoCustomGenerator extends SeoGenerator {

	protected function alterAfterSave($Model, $currentTags) {
		return $currentTags;
	}

	protected function alterAtRuntime($page, $allTags, $request) {

		# Get active language
		$lang = $request->params['language'];
		if($page['Page']['id'] == 10 && $page['Page']['slug'] != end($request->params['pass'])) {

			# Get place title
			$placeTitle = ClassRegistry::init('Place')->field('title', array(
				'Place.slug' => end($request->params['pass'])
			));

			$allTags[1][$lang] = __('Slike') . ' - ' . $placeTitle;
			return $this->generateChildTags($allTags) + $allTags;

		} else if($page['Page']['parent_id'] == 10) {

			$allTags[1][$lang] = __('Slike') . ' - ' . $page['Page']['title'];
			return $this->generateChildTags($allTags) + $allTags;
		}

		return $allTags;
	}

}
