<?php

use IntellexApps\PHP\UploadFile\Domain\Service\ServiceContainer;
use IntellexApps\PHP\UploadFile\Routing\Router;

define('DS', DIRECTORY_SEPARATOR);
define('ROOT_DIR', dirname(__DIR__) . DS);
define('CONFIG_DIR', __DIR__ . DS);


require_once __DIR__ . DS . 'config.php';
require_once __DIR__ . DS . 'functions.php';


ServiceContainer::instance();


define('GLOBAL_NAMESPACE', 'IntellexApps\PHP\UploadFile');

// Set error handler
set_error_handler(function($e) {
    call_user_func_array('\IntellexApps\PHP\UploadFile\Handler\ErrorHandler::handle', func_get_args());
});

// Set exception handler
set_exception_handler(function($e) {
    call_user_func_array('\IntellexApps\PHP\UploadFile\Handler\ExceptionHandler::handle', func_get_args());
});

// Shutdown handler
register_shutdown_function(function() {

    // Default error info
    $errfile = "unknown file";
    $errstr  = "shutdown";
    $errno   = E_CORE_ERROR;
    $errline = 0;

    $error = error_get_last();

    if($error !== NULL) {

        // Collect error info
        $errno   = $error["type"];
        $errfile = $error["file"];
        $errline = $error["line"];
        $errstr  = $error["message"];

        // Call fatal error handler
        call_user_func_array('\IntellexApps\PHP\UploadFile\Handler\ErrorHandler::handleFatal', array($errno, $errstr, $errfile, $errline));
    }
});


// Configure routes
$routeConfiguration = require __DIR__ . DS . 'routes.php';
Router::configureRoutes($routeConfiguration);
