<?php
namespace IntellexApps\PHP\UploadFile\Controller;

use IntellexApps\PHP\UploadFile\Domain\Model\FolderItem;
use IntellexApps\PHP\UploadFile\Domain\Request\CopyRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\CreateRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\DeleteRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\ListFilesRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\MoveRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\Permission\ChangePermissionRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\RenameRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\UploadRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\ViewItemRequest;
use IntellexApps\PHP\UploadFile\Domain\Response\StatusResponse;
use IntellexApps\PHP\UploadFile\Domain\Service\PermissionService;
use IntellexApps\PHP\UploadFile\Dossier;
use IntellexApps\PHP\UploadFile\Network\HtmlResponse;
use IntellexApps\PHP\UploadFile\Util\Configuration;
use IntellexApps\PHP\UploadFile\Util\Controller;
use Swagger\Annotations as SWG;

class RenderController extends Controller
{

    /**
     * Render iframe content
     *
     * @return HtmlResponse
     */
    public function iframeAction()
    {
        if(!isset($this->request->data['dossier_id'])) {
            die('Invalid request - missing dossier_id param');
        }

        $id = $this->request->data['dossier_id'];

        $instance = new Dossier($id);

        $config = $instance->getJsConfig();

        $htmlResponse = new HtmlResponse();
        $htmlResponse
            ->setData([
                'id' => $id,
                'config' => $config,
                'dossier' => $instance
            ])
            ->setTemplate('Render/iframe.phtml');
        return $htmlResponse;
    }


    /**
     * Generate thumbnails
     */
    public function thumbnailAction()
    {
        $this->container->get('thumbnail')->outputThumbnail(
            $this->request->data['item']
        );
    }
}
