<?php
namespace IntellexApps\PHP\UploadFile\Controller;

use IntellexApps\PHP\UploadFile\Domain\Request\File\MultipartUploadRequest;
use IntellexApps\PHP\UploadFile\Domain\Service\UploadFileService;
use IntellexApps\PHP\UploadFile\Util\Controller;
use Swagger\Annotations as SWG;

class UploadController extends Controller
{

    /** @var UploadFileService */
    var $uploadFileService = null;

    /**
     * Initialize controller
     */
    protected function init()
    {
        $this->uploadFileService = $this->container->get('upload');
    }

    /**
     * List files
     *
     * TODO: Improve this
     *
     * @SWG\Post(
     *     path="/upload/multipart",
     *     description="Multipart upload",
     *     @SWG\Response(
     *         response=200,
     *         description="Status list"
     *     ),
     *     @SWG\Response(
     *         response="default",
     *         description="unexpected error",
     *         @SWG\Schema(ref="#/definitions/ErrorModel")
     *     )
     * )
     */
    public function multipartAction()
    {
        return $this->uploadFileService->multipartUpload(
            new MultipartUploadRequest($this->request)
        );
    }
}