<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\FileSystem;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Service\FileSystemService;

class DirectoryAlreadyExistsException extends UploadFileException
{
    /**
     * Construct default message
     *
     * DirectoryAlreadyExistsException constructor.
     * @param string $path
     */
    public function __construct($path)
    {
        parent::__construct(__('Directory already exists: %s', FileSystemService::relativePath($path)));
    }
}
