<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\Request;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;

class MissingParamsException extends UploadFileException {

    var $params;

    /**
     * MissingParamsException constructor.
     * @param string $params
     */
    public function __construct($params)
    {
        $this->setParams($params);
        parent::__construct(__('Missing params: %s', join(',', $this->getParams())));
    }

    /**
     * @return mixed
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * @param mixed $params
     */
    public function setParams($params)
    {
        $this->params = $params;
    }
}