<?php
namespace IntellexApps\PHP\UploadFile\Domain\Model;

/**
 * @SWG\Definition(definition="FolderItemMeta", type="object")
 */
class FolderItemMeta extends UploadFileModel
{
    /**
     * @var string
     * @SWG\Property()
     */
    public $alt;

    /**
     * @var int
     * @SWG\Property()
     */
    public $height;

    /**
     * @var int
     * @SWG\Property()
     */
    public $width;

    /**
     * @var int
     * @SWG\Property()
     */
    public $duration;

    /**
     * Construct folder item
     *
     * FolderItem constructor.
     * @param $path
     */
    public function __construct($path)
    {
        $this->buildFromPath($path);
    }

    /**
     * Build from path
     *
     * @param $path
     */
    private function buildFromPath($path)
    {
    }
}