<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;

/**
 * @SWG\Definition(definition="CopyRequest", type="object", required={"paths","name","type"})
 */
class CompressRequest extends ApiRequest
{

    /**
     * @var array
     * @SWG\Property()
     */
    var $paths;

    /**
     * @var string
     * @SWG\Property()
     */
    var $name;

    /**
     * @var string
     * @SWG\Property()
     */
    var $type;

    /**
     * Build from request
     *
     * @param Request $request
     */
    protected function build(Request $request)
    {
        $this->requireParams([
            'paths', 'name', 'type'
        ]);


        $this->paths = $request->get('source');
        $this->name = $request->get('destination');
        $this->type = $this->validateType($request->get('type'));
    }

    /**
     * @return mixed
     */
    public function getPaths()
    {
        return $this->paths;
    }

    /**
     * @param mixed $paths
     * @return CopyRequest
     */
    public function setPaths($paths)
    {
        $this->paths = $paths;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return CopyRequest
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Validate type
     *
     * @param $get
     * @return bool
     * @throws UploadFileException
     */
    private function validateType($get)
    {
        $validTypes = [
            'zip',
            'tar',
            'tar.gz',
            'tar.bz2'
        ];

        if(!in_array($get, $validTypes)) {
            throw new UploadFileException(__('Invalid value of "type" param: %s. Valid values %s', $get, join(',' ,$validTypes)));
        }

        return true;
    }

}