<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;
use IntellexApps\PHP\UploadFile\Util\Inflector;

/**
 * @SWG\Definition(definition="CreateRequest", type="object", required={"path"})
 */
class CreateRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * Build from request
     *
     * @param Request $request
     */
    public function build(Request $request)
    {
        $this->requireParams(['path']);
        $this->path = Inflector::leadingSeparator($request->data['path']);
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }
}