<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;

/**
 * @SWG\Definition(definition="RenameRequest", type="object", required={"source","destination"})
 */
class RenameRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $source;

    /**
     * @var string
     * @SWG\Property()
     */
    var $destination;

    /**
     * Build from request
     *
     * @param Request $request
     */
    protected function build(Request $request)
    {
        $this->requireParams([
            'source', 'destination'
        ]);

        $this->source = $request->get('source');
        $this->destination = $request->get('destination');
    }

    /**
     * @return mixed
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * @param mixed $source
     * @return RenameRequest
     */
    public function setSource($source)
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * @param mixed $destination
     * @return RenameRequest
     */
    public function setDestination($destination)
    {
        $this->destination = $destination;
        return $this;
    }

}