<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;

/**
 * @SWG\Definition(definition="UpdatePermissionsRequest", type="object", required={"path","permissions"})
 */
class UpdatePermissionsRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * @var object
     * @SWG\Property()
     */
    var $permissions;

    /**
     * @var boolean
     * @SWG\Property()
     */
    var $recursive = false;

    /**
     * Build from request
     *
     * @param Request $request
     */
    protected function build(Request $request)
    {
        $this->requireParams([
            'path', 'permissions'
        ]);

        $this->path = $request->get('path');
        $this->permissions = $request->get('permissions');

        if($request->get('recursive')) {
            $this->recursive = $request->get('recursive');
        }
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param mixed $path
     * @return RenameRequest
     */
    public function setPath($path)
    {
        $this->path = $path;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getPermissions()
    {
        return $this->permissions;
    }

    /**
     * @param mixed $permissions
     * @return RenameRequest
     */
    public function setPermissions($permissions)
    {
        $this->permissions = $permissions;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isRecursive()
    {
        return $this->recursive;
    }

}