<?php
namespace IntellexApps\PHP\UploadFile\Domain\Service;

class BaseService
{

    /** @var ServiceContainer */
    var $container;

    /**
     * Default constructor
     *
     * BaseService constructor.
     * @param ServiceContainer $container
     */
    public function __construct(ServiceContainer $container)
    {
        $this->container = $container;
    }

    /**
     * Initi function - to be called in subclasses
     */
    public function init() {}

    /**
     * Get another service
     *
     * @param $serviceName
     * @return mixed
     */
    public function get($serviceName)
    {
        return $this->container->get($serviceName);
    }

}