<?php
namespace IntellexApps\PHP\UploadFile\Network;

class HtmlResponse extends Response
{
    var $data = array();
    var $template = array();

    /**
     * Set data
     *
     * @param $data
     * @return $this
     */
    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * Set template
     *
     * @param $template
     * @return $this
     */
    public function setTemplate($template)
    {
        $this->template = $template;
        return $this;
    }

    /**
     * Convert to json before sending to client
     * @return string
     * @throws \Exception
     */
    protected function getBody()
    {
        $templateLocation = ROOT_DIR . 'View' . DS . $this->template;

        if(!file_exists($templateLocation)) {
            throw new \Exception(sprintf('Template %s not found', $this->template));
        }

        ob_start();
        extract($this->data);
        include $templateLocation;
        $html = ob_get_clean();

        return $html;
    }
}