<?php
namespace IntellexApps\PHP\UploadFile\Util;

class Configuration {

    /** @var array config */
    public static $config = [];

    /** @var array hooks */
    public static $hooks = [];

    /**
     * Load configuration
     *
     * @param $config
     */
    public static function load($config)
    {
        self::$config = $config['config'];
        self::$hooks= $config['hooks'];
        $_SESSION['dossier']['last_loaded_config'] = $config;
    }

    /**
     * Read configuration from key
     *
     * @param $key
     * @return mixed|null
     */
    public static function read($key)
    {
        if(isset(self::$config[$key])) {
            return self::$config[$key];
        }

        return null;
    }
}
