<?php
namespace IntellexApps\PHP\UploadFile\Util;


use IntellexApps\PHP\UploadFile\Domain\Service\ServiceContainer;
use IntellexApps\PHP\UploadFile\Network\Request;
use IntellexApps\PHP\UploadFile\Network\Response;

class Controller
{

    public $name = null;

    /** @var Request|null */
    protected $request = null;

    /** @var Response|null */
    protected $response = null;

    /** @var ServiceContainer */
    protected $container = null;

    /**
     * Construct controller
     *
     * BaseController constructor.
     * @param $name
     * @param Request $request
     * @param Response $response
     */
    public function __construct($name, Request $request, Response $response)
    {
        $this->name = $name;
        $this->request = $request;
        $this->response = $response;

        $this->container = ServiceContainer::instance();

        $this->init();
    }

    /**
     * Initialize function
     */
    protected function init()
    {}

    /**
     * @return null
     */
    public function getName()
    {
        return $this->name;
    }

}