<?php
namespace IntellexApps\PHP\UploadFile\Util;

class Inflector
{

    /**
     * Classify string
     *
     * @param $string
     * @return mixed
     */
    public static function classify($string)
    {
        return str_replace(' ', '', ucwords(str_replace('-', ' ', $string)));
    }

    /**
     * Camel case string
     *
     * @param $string
     * @return mixed
     */
    public static function camel($string)
    {
        $str = str_replace(' ', '', ucwords(str_replace('-', ' ', $string)));
        $str[0] = strtolower($str[0]);
        return $str;
    }

    public static function leadingSeparator($string)
    {
        if($string[0] != DS) {
            $string = DS . $string;
        }

        return $string;
    }


    public static function followingSeparator($string)
    {
        if($string[strlen($string) - 1] != DS) {
            $string = $string . DS;
        }

        return $string;
    }

    /**
     * Join paths
     *
     * @param $paths
     * @return string
     */
    public static function joinPaths($paths)
    {
        $newPaths = [];

        $firstChar = $paths[0][0];
        $lastChar = end($paths[count($paths)-1]);

        foreach($paths as $index => $path) {
            $newPaths[] = trim($path, DS);
        }

        $joined = join(DS, $newPaths);

        if($joined[0] != $firstChar) {
            $joined = $firstChar . $joined;
        }

        if($joined[strlen($joined) - 1] != $lastChar) {
            $joined = $joined . $lastChar;
        }

        return $joined;
    }
}