<?php

class XlsxAdapter {


# ~ Export data to XLSX file format- - - - - - - - - - - - - - - - - - - - - - #
	public function export($records, $columns, $filename = null) {

		$columns = array_values($columns);

		# Prepare records for export
		foreach($records as $index => $record) {
			$records[$index] = array_values($record);
		}

		# Append columns to records
		array_unshift($records, $columns);

		# Load library
		require_once(VECTORCMS_ROOT . 'Vendor' . DS . 'XlsxWriter' . DS . 'xlsxwriter.class.php');

		# Get filename
		$filename = date('Y.m.d H:i') . '-' . $filename . '.xlsx';

		# Write XLSX
		$writer = new XLSXWriter();
		$writer->writeSheet($records);

		# Output file
		header("Content-Disposition: attachment; filename=\"$filename\"");
		header("Content-Type: application/vnd.ms-excel");
		$writer->writeToStdOut();
		die;

	}

}
