<?php namespace Puzzle;
class Image {

	/** @var string The source of the image. **/
	private $src;

	/** @var float The X coordinate of the image, in percentage of the canvas size. **/
	private $x;

	/** @var float The Y coordinate of the image, in percentage of the canvas size. **/
	private $y;

	/** @var int The ordering of the image on the canvas. **/
	private $order;

	/**
	 * Initialize the image.
	 *
	 * @param	string	$src	The source of the image.
	 * @param	float	$x		The X coordinate of the image, in percentage of the canvas size.
	 * @param	float	$y		The Y coordinate of the image, in percentage of the canvas size.
	 * @param	int		$order	The ordering of the image on the canvas.
	 */
	public function __construct($src, $x, $y, $order = -1) {

		# Validate the image exists
		if(!is_file($src) || !is_readable($src)) {
			throw new Exception\ImageNotFoundException($src);
		}

		# Set up
		$this->src = $src;
		$this->x = $x;
		$this->y = $y;
		$this->order = $order;
	}

	/**
	 * Get the color from the supplied string.
	 *
	 * @param	string	$color	The
	 *
	 * @param	Color	The parsed color.
	 */
	private function getColor($color) {
		return \Color::fromHex($color);
	}

	public function getSource() {
		return $this->src;
	}

	public function getX() {
		return $this->x;
	}

	public function gety() {
		return $this->y;
	}

	public function getOrder() {
		return $this->order;
	}

}
