<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.console.libs.templates.views
 * @since         CakePHP(tm) v 1.2.0.5234
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

Timer::start('scaffold');
{

	$model = ClassRegistry::init($modelClass);
	$schema = $model->schema(true);
	foreach ($schema as $field => $params)
		if (substr($params['type'], 0, 4) == 'enum') {
			$schema[$field]['type'] = 'enum';
		}

	$parentModel = null;
	if (!empty($records)) {
		$parentModel = ClassRegistry::init($records[0][$model->alias]['model']);
	}
	$parents = [];

	# Set default ordering visible
	if (!empty($model->order) && empty($this->request->params['paging'][$model->alias]['options']['order'])) {
		$this->request->params['paging'][$model->alias]['options']['order'] = $model->order;
	}

	$showSidebar = !empty($category_tree) || !empty($tree);

	$classMapping = [
		'float'       => 'int',
		'integer'     => 'int',
		'string'      => 'char',
		'enum'        => 'char',
		'text'        => 'text',
		'tinytext'    => 'text',
		'boolean'     => 'bool',
		'datetime'    => 'time',
		'date'        => 'date',
		'association' => 'img'
	];

	Timer::start('field prepration');
	{

		$showFields = [];
		if (isset($administrator['Administrator']['customization'][$modelClass])) {
			foreach ($administrator['Administrator']['customization'][$modelClass] as $field => $params) {
				if (!empty($params['show']) && !in_array($field, $model->invisible) && ($model->schema($field) || isset($model->hasOne[$field]))) {
					$column['ordering'] = isset($params['ordering']) ? $params['ordering'] : PHP_INT_MAX;
					$column['field'] = $field;
					$column['label'] = Inflector::humanize($field);
					$column['type'] = $model->schema($field) ? reset(explode('(', $model->_schema[$field]['type'])) : 'association';
					switch (true) {
						case $column['field'] == $model->displayField:
							$column['class'] = 'title';
							break;
						case substr($column['field'], -3) == '_id':
							$column['class'] = 'char';
							break;
						default:
							$column['class'] = isset($classMapping[$column['type']]) ? $classMapping[$column['type']] : null;
					}
					$showFields[] = $column;
				}
			}
		}

		if (empty($showFields)) {
			$showFields[] = [
				'ordering' => 0,
				'field'    => $model->displayField,
				'label'    => Inflector::humanize($model->displayField),
				'type'     => 'string',
				'class'    => 'title'
			];
		}

		$showFields = Set::sort($showFields, '{n}.ordering', ASC);

	}
	Timer::end('field prepration');
	?>

	<?= $this->Html->script('dragtable', false, [ 'inline' => false ]) ?>

	<?php if ($showSidebar) { ?>
	<?= $this->element('index/side_bar') ?>
<?php } ?>

	<div class="header<?= $showSidebar ? ' with-sidebar' : null ?>">
		<?php
		Timer::start('Buttons');
		{

			echo $this->Format->actions(array_merge(
				[

					# Add new
					$model->isAddable()
						? [ 'plus', __('Add new'), [ C => $controller, A => 'add' ], [ 'class' => 'btn btn-success' ] ]
						: [],

					# Edit module
					$model->isModule && !empty($isSuperadmin)
						? [ 'magic', __('Edit module'), [ C => 'modules', A => 'edit', $model->moduleId ], [ 'class' => 'btn' ] ]
						: [],

					# Edit
					$model->isModule && $model->hasDetails
						? [ 'file-text-o', __('Edit template'), [ C => 'pages', A => 'module', $modelClass ] ]
						: [],

					# Categories
					$model->schema('category_id')
						? [ 'folder-open', __('View categories'), [ C => $controller, A => 'categories' ] ]
						: [],

					# Comments
					$model->isModule && $model->hasComments
						? [ 'align-left', __('View comments'), [ C => $controller, A => 'comments' ] ]
						: [],

					# Customize view
					[ 'columns', __('Customize view'), '#CustomizeTableModal', [ 'class' => 'btn', 'role' => 'button', 'data-toggle' => 'modal' ] ],

					# Treesort
					!empty($treeview)
						? [ 'code-fork', __('Sort'), '#SortTreeModal', [ 'class' => 'btn', 'role' => 'button', 'data-toggle' => 'modal' ] ]
						: [] ],

				# Additional actions from controller
				$_actions,

				# Filter
				[ $this->Format->filter() ]
			));

			# For tree view
			if (!empty($treeview)) {
				echo $this->element('index/sort_tree');
			}

			# Customize view
			echo $this->element('index/customize_table');

		}
		Timer::end('Buttons');

		# Filter
		Timer::start('Filter');
		{

			$filter = [ '_keyword' ];
			$keywords = false;
			$ignoreFilter = [ 'id', 'ordering', 'modified', 'modified_by', 'created', 'created_by' ];
			foreach ($schema as $field => $params)
				if (!in_array($params['type'], [ 'string', 'text' ]) && !in_array($field, array_merge($ignoreFilter, $model->invisible))) {
					$filter[] = $field;
				}
			echo $this->Format->filter($filter);

		}
		Timer::end('Filter');
		?>
	</div>

	<div class="<?= $plural ?> index<?= $showSidebar ? ' with-sidebar' : null ?>">
		<?php if (!empty($records)) { ?>

			<div class="table-options clearfix">
				<?= $this->element('index/multiselect', [ 'model' => $model ]) ?>
				<?= $this->element('index/paginator') ?>
			</div>

			<form id='emailSendForm' method="post" action="">
				<table cellpadding="0" cellspacing="0" class="draggable" id="<?= $model->alias ?>Index">
					<tr>
						<th class="box">&nbsp;</th>
						<?php foreach ($showFields as $field) { ?>
							<th id="th-<?= $field['field'] ?>" class="<?= $field['class'] ?>"><?= !empty($this->request->params['all']) ? str_replace('/index/all/', '/all/', $this->Paginator->sort($field['field'])) : $this->Paginator->sort($field['field']) ?></th>
						<?php } ?>
						<th class="actions"><?= __('Commented on') ?></th>
						<th class="actions"><?= __('Actions') ?></th>
					</tr>
					<?php Timer::start('output');
					{ ?>
						<?php foreach ($records as $i => $record) { ?>
						<?php

						# For tree view
						$additional = '';
						if (!empty($treeview)) {
							$additional = !empty($record[$model->alias]['parent_id']) ? " data-tt-parent-id=\"{$record[$model->alias]['parent_id']}\"" : null;
						}
						$additional .= ' class="' . ($i % 2 ? 'even' : 'odd') . '"';
						?>
						<tr id="<?= $record[$model->alias][$model->primaryKey] ?>" data-tt-id="<?= $record[$model->alias][$model->primaryKey] ?>"<?= $additional ?>>
							<td class="box">
								<input type="checkbox" id="PageBox-<?= $record[$model->alias][$model->primaryKey] ?>" value="<?= $record[$model->alias][$model->primaryKey] ?>" name="data[Page][box-<?= $record[$modelClass][$model->primaryKey] ?>]">
								<?php
								foreach ($showFields as $i => $field) {
									$class = '';
									$value = !empty($record[$modelClass][$field['field']]) ? strip_tags($record[$modelClass][$field['field']]) : '';
									switch ($field['field']) {
										default:

											# Display field
											if ($field['class'] == 'title') {
												if ($model->isEditable($record[$modelClass][$model->primaryKey])) {
													$value = $this->Html->link($record[$modelClass][$field['field']], [ C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey] ]);
												} else {
													$value = $this->Html->link($record[$modelClass][$field['field']], [ C => $controller, A => 'view', $record[$modelClass][$model->primaryKey] ]);
												}
												# Special fields
											} else if ($field['field'] == 'url') {
												$value = $this->Html->link(preg_replace('~^[^:]*://~', '', $value), $value, [ 'target' => '_blank' ]);

												# Associative fields
											} else if (($id = substr($field['field'], -3) == '_id') || (($var = Inflector::variable(Inflector::pluralize($field['field']))) && isset($$var))) {
												if ($id) {
													$var = Inflector::variable(Inflector::pluralize(substr($field['field'], 0, -3)));
												}
												$var = $$var;
												$value = isset($var[$value]) ? $var[$value] : null;

												# Uploads
											} else if (isset($record[$field['field']])) {
												if (!empty($record[$field['field']]['filename'])) {
													$value = $this->Format->image($record[$field['field']], 74, 36, $field['field']);
												} else {
													$value = $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]);
												}

												# Other fields
											} else {
												$class = $classMapping[$schema[$field['field']]['type']];
												switch ($model->_schema[$field['field']]['type']) {
													case 'boolean':
														$value = $this->Format->toggle($controller, $record[$modelClass], $field['field']);
														break;
													case 'date':
														$value = $this->Format->time($value);
														break;
													case 'datetime':
														$value = $this->Format->time($value, true);
														break;
												}
											}
									}
									$class = !empty($field['class']) ? ' class="' . $field['class'] . '"' : '';

									echo "<td{$class}>{$value}</td>\n";
								}
								?>
							<td class="char">
								<?php
								$parentKey = $record[$model->alias]['foreign_key'];
								if (!isset($parents[$parentKey])) {
									$parent = $parentModel->find('first', $parentKey);
									$parents[$parentKey] = $parent;
								}
								$link = str_replace('admin.', '', FULL_BASE_URL);
								$link .= $this->Front->getModulePath($parents[$parentKey]);
								echo $this->Html->link($parents[$parentKey][$parentModel->alias][$parentModel->displayField], $link, [ 'target' => '_blank' ]);
								?>
							</td>
							<td class="actions">
								<?php
								Timer::startLoop('Actions');
								{
									echo $this->Format->actions([

										# View
										$model->Alias == 'Page'
											? [ 'eye', '', $this->Format->pageLink($record[$modelClass][$model->primaryKey]), [ 'class' => 'btn btn-sm btn-icon-only', 'target' => '_blank' ] ]
											: [ 'eye', '', [ C => $controller, A => 'view', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-sm btn-icon-only' ] ],

										# Edit
										$model->isEditable($record[$modelClass][$model->primaryKey])
											? [ 'pencil', '', [ C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-sm btn-icon-only' ] ]
											: [],

										# Delete
										$model->isDeletable($record[$modelClass][$model->primaryKey])
											? [ 'trash-o', '', [ C => $controller, A => 'delete', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-sm btn-icon-only btn-danger', 'confirm' => __('Are you sure you want to delete') . ":\n" . $record[$modelClass][$model->displayField] . ' ?' ] ]
											: []
									]);
								}
								Timer::endLoop('Actions');
								?>
							</td>
						</tr>
					<?php } ?>
					<?php }
					Timer::end('output') ?>
				</table>
			</form>

			<div class="table-options clearfix">
				<?= $this->element('index/multiselect', [ 'model' => $model ]) ?>
				<?= $this->element('index/paginator', [ 'bottom' => true ]) ?>
			</div>

			<script type="text/javascript">
				$('#<?= $model->alias ?>Index .bool a[class^=switch_]').click(function () {
					$(this).children('img').attr('src', $(this).children('img').attr('src').replace(/[0_1].png$/, 'loader_small.gif'));
					$.get(
						$(this).attr('href'),
						function (response) {
							if (response == 'Error!') return;
							if (typeof(response) == 'string') {
								eval('response = ' + response + ';');
							}
							if (response.single && response.value != '0') {
								var imgs = $('#<?= $model->alias ?>Index td a[class^=switch_' + response.field + '_]:not(#<?= $model->alias ?>Index .bool a.switch_' + response.field + '_' + response.id + ') > img');
								imgs.attr('src', imgs.attr('src').replace(/[0_1].png$/, '0.png'));
							}
							var img = $('#<?= $model->alias ?>Index .bool a.switch_' + response.field + '_' + response.id + ' > img');
							img.attr('src', img.attr('src').replace('loader_small.gif', response.value + '.png'));
						}
					);
					return false;
				});
				<?php if($treeview) { ?>
				$(function () {
					$("#<?= $model->alias ?>Index").treetable({
						column: 1,
						expandable: true,
						initialState: 'expanded',
						stringExpand: '<?= __('Expand') ?>',
						stringCollapse: '<?= __('Collapse') ?>'
					});
				});
				<?php } ?>
			</script>

		<?php } else { ?>
			<div class="empty well">
				<?php if (empty($this->request->params['filter'])) { ?>
					<?= __('There are no records for this module in the database.') ?>
					<?php if (in_array($this->request->params[C], Set::extract('/Module/use_table', Stash::read('modules')))) { ?>
						<br /><br />
						<?= $this->Html->link(__('Click here to populate with random records.'), [ C => $controller, A => 'populate', 14 ]) ?>
					<?php } ?>
				<?php } else { ?>
					<?= __('No records have been found, please refine your search.') ?>
				<?php } ?>
			</div>
		<?php } ?>

	</div>

	<?php $newsletters = ClassRegistry::init('Newsletter')->find('all') ?>

	<div id="ChooseTemplateModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
			<h3><?= __('Choose new or existing newsletter as template') ?></h3>
		</div>

		<div class="modal-body">
			<select name="newsletter-type" class="newsletter-type-select">
				<option value=""><?= __('New') ?></option>
				<?php foreach ($newsletters as $newsletter) { ?>
					<option value="<?= $newsletter['Newsletter']['id'] ?>"><?= $newsletter['Newsletter']['newsletter_name'] ?></option>
				<?php } ?>
			</select>
		</div>

		<div class="modal-footer">
			<input type="button" class="btn btn-primary create-newsletter" value="<?= __('Prepare newsletter') ?>" data-click-feedback="<?= __('Please wait...') ?>" />
		</div>
	</div>

	<script type="text/javascript">
		$(function () {
			$('.send-emails').click(function (event) {
				event.preventDefault();

			});

			$('.create-newsletter').click(function () {
				var selectedTemplate = $(".newsletter-type-select").val();
				$('form#emailSendForm').attr('action', "/<?= $locale ?>/newsletter/prepare/<?= $model->alias ?>/" + selectedTemplate).submit();
			});
		})
	</script>

<?php }
Timer::end('scaffold') ?>
