<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright        Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link             http://cakephp.org CakePHP(tm) Project
 * @package          cake
 * @subpackage       cake.cake.console.libs.templates.views
 * @since            CakePHP(tm) v 1.2.0.5234
 * @license          MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
Timer::start('scaffold');
{

	$model = ClassRegistry::init($modelClass);
	$schema = $model->schema(true);
	foreach ($schema as $field => $params)
		if (substr($params['type'], 0, 4) == 'enum') {
			$schema[$field]['type'] = 'enum';
		}
	$skip = [
		'id',
		'category_id',
		'published',
		'release_date',
		'ordering',
		'slug',

		'is_active',
		'is_deleted',
		'is_translated',

		'modified',
		'modified_by',
		'created',
		'created_by'
	];

	$languages = Configure::read('Config.Languages');
	?>

	<div class="view-bar">
		<?php

		# Deleted
		if (!empty($record[$modelClass]['is_deleted'])) {
			echo '<div class="status status-error">' . __('This record has been deleted') . '</div>';
		}

		# Display image
		if (!empty($model->displayImage)) {
			if (!empty($record[$model->displayImage]['filename'])) {
				echo '<div class="display-image">' . $this->Format->image($record[$model->displayImage], 260, null, $model->displayImage, [ 'class' => 'display-image' ]) . '</div>';
			} else {
				echo '<div class="empty well">' . __('No ' . preg_replace('~(?<=.)([A-Z])~', ' $1', $model->displayImage)) . '</div>';
			}
		}

		# Active
		if (empty($record[$modelClass]['is_deleted']) && isset($record[$modelClass]['is_active'])) {
			echo $record[$modelClass]['is_active']
				? '' //'<div class="status status-success">' . __('This record is active') . '</div>'
				: '<div class="status status-warning">' . __('This record is inactive') . '</div>';
		}

		# ID
		if (isset($record[$modelClass]['id'])) {
			echo '<div class="view-bar-section">';
			echo '<span class="right">' . $record[$modelClass]['id'] . '</span>';
			echo '<b>' . __('Unique ID') . ':</b>';
			echo '</div>';
		}

		# Ordering
		if (isset($record[$modelClass]['ordering'])) {
			echo '<div class="view-bar-section">';
			echo '<span class="right">' . $record[$modelClass]['ordering'] . '</span>';
			echo '<b>' . __('Ordering') . ':</b>';
			echo '</div>';
		}

		# Category
		if (isset($record[$modelClass]['category_id']) && !empty($record['Category'])) {
			$spans = [];
			foreach ($languages as $locale => $language) {
				//$spans[] = $this->Html->tag('span', $record['Category']['title__'][$locale], array('class' => 'list lang lang-' . $locale, 'style' => 'display:' . ($locale == Configure::read('Config.language') ? 'inline' : 'none')));
			}
			$spans = [ $record['Category']['title'] ];
			$link = $this->Html->link(implode($spans), [ C => $controller, A => 'categories', 'view', $record[$modelClass]['category_id'] ], [ 'class' => 'right', 'title' => __('Show category details') ]);
			$value = $this->Html->tag('b', __('Category') . ':');
			echo $this->Html->tag('div', $link . $value);
		}

		# Release date
		$dates = [ 'release_date', 'published' ];
		foreach ($dates as $date)
			if (isset($record[$modelClass][$date])) {
				echo '<div class="view-bar-section">';
				echo '<span class="right">' . $this->Format->time($record[$modelClass][$date]) . '</span>';
				echo '<b>' . __('Release date') . ':</b>';
				echo '</div>';
				break;
			}

		# Languages
		if (sizeof($languages) > 1 && isset($record[$modelClass]['is_translated'])) {
			$count = 0;
			echo '<div class="view-bar-section">';
			foreach ($languages as $locale => $language) {
				if (!empty($record[$modelClass]['is_translated__'][$locale])) {
					$count++;

					$icon = !empty($language['Icon']['filename'])
						? $this->Html->image('/' . $language['Icon']['path'] . $language['Icon']['filename'])
						: $language['Language']['locale'];
					echo $this->Html->link($icon, 'javascript: void(0)', [ 'class' => 'flag right' . ($locale == Configure::read('Config.language') ? ' flagged' : ''), 'title' => $language['Language']['title'], 'rel' => $locale ]);
				}
			}
			if (!$count) {
				echo '<span class="right no-languages" title="' . __("This {$singular} is not translated to any language") . '">' . __('no language') . '</span>';
			}
			echo '<b>' . __('Translated to') . ':</b>';
			echo '</div>';
		}

		# Uploads
		foreach ([ 'hasOne', 'hasMany' ] as $type) {
			foreach ($model->$type as $association => $params)
				if ($params['className'] == 'Upload') {

					# Single upload
					if ($type == 'hasOne') {

						# Skip display image, it has already been shown
						if ($association == $model->displayImage)
							continue;

						# Always display as documents
						$documents = true;
						$record[$association] = [ $record[$association] ];

						# Multiple upload
					} else {

						# Check if should be displayed as documents
						$documents = false;
						foreach ($record[$association] as $i => $file) {
							if (!empty($file['filename']) && !in_array(strtolower(lastFromDot($file['filename'])), [ 'jpg', 'jpeg', 'png', 'gif' ])) {
								$documents = true;
								break;
							}
						}
					}

					# Output subtitle
					echo '<strong style="clear:left">' . preg_replace('~(?<=.)([A-Z])~', ' $1', $association) . '</strong>';

					# There are some uploads
					$empty = $type === 'hasMany' ? empty($record[$association]) : empty($record[$association][0]['filename']);
					if (!$empty) {
						foreach ($record[$association] as $i => $file)
							if (!empty($file['filename'])) {

								# Uploads contains documents
								if ($documents) {
									$fancybox = '';
									$extension = strtolower(lastFromDot($file['filename']));

									# Image
									if (in_array($extension, [ 'jpg', 'jpeg', 'gif', 'png' ])) {
										$image = $this->Format->image($file, 80, null, false);

										# PDF
									} else if ($extension == 'pdf') {
										$image = $this->Format->image($file, 80, null, false);

										# Other documents
									} else {
										$mime = lastFromDot($file['filename']);
										if (!is_file(WWW_ROOT . "/img/mimetypes/{$mime}.png")) {
											$mime = 'default';
										}
										$image = $this->Html->image("mimetypes/{$mime}.png");
									}

									# Output
									echo $this->Html->link(
										$image . $this->Html->tag(
											'div',
											'<span>' . str_replace('_', ' ', $file['filename']) . '</span>' .
											'<em>' . $this->Format->filesize($file['filesize']) . '</em>'),
										$file['file'],
										[
											'class'  => $fancybox . 'view-bar-direct-link',
											'target' => '_blank' ]
									);
									echo '<div class="clear"></div>';

									# Uploads contains only Images
								} else {
									$class = !(($i - 1) % 3) ? ' middle' : (!($i % 3) ? ' clear-left' : '');
									echo $this->Format->image($file, 84, 55, [ 'class' => 'view-bar-gallery' . $class, 'rel' => $association ]);
								}
							}

						# No uploads
					} else {
						echo '<p class="empty-small">' . __('No ' . preg_replace('~(?<=.)([A-Z])~', ' $1', $association)) . '</p>';
					}
				}
		}

		# More details
		echo $this->Html->link(__('show more'), '#moreDetails', 'more-details');
		echo '<div class="view-bar-more-details">';

		# Slug
		if ($model->isModule && $model->hasDetails) {
			echo '<div class="view-bar-section">';
			echo '<span class="right">' . $record[$modelClass]['slug'] . '</span>';
			echo '<b>' . __('Unique slug') . ':</b>';
			echo '</div>';
		}

		# Created
		echo '<div class="view-bar-section">';
		echo '<span class="right">' . $this->Format->time($record[$modelClass]['created']) . '</span>';
		echo '<b>' . __('Created') . ':</b>';
		echo '</div>';

		if (isset($createdBies[$record[$modelClass]['created_by']])) {
			echo '<div class="view-bar-section">';
			echo '<b>&nbsp;</b>';
			echo '<span class="right">' . __('by') . ' ' . $createdBies[$record[$modelClass]['created_by']] . '</span>';
			echo '</div>';
		}

		# Modified
		echo '<div class="view-bar-section">';
		echo '<span class="right">' . $this->Format->time($record[$modelClass]['modified']) . '</span>';
		echo '<b>' . __('Last modified') . ':</b>';
		echo '</div>';

		if (isset($modifiedBies[$record[$modelClass]['modified_by']])) {
			echo '<div class="view-bar-section">';
			echo '<b>&nbsp;</b>';
			echo '<span class="right">' . __('by') . ' ' . $modifiedBies[$record[$modelClass]['modified_by']] . '</span>';
			echo '</div>';
		}

		echo '</div>';
		?>
	</div>

	<div class="header with-sidebar">
		<div class="btn-group pull-right" data-toggle="buttons-radio" style="margin-right:10px">
			<button type="button" class="btn active" onclick="toggleHistory('overview')"><?php echo __('Overview'); ?></button>
			<button type="button" class="btn" onclick="toggleHistory('history')"><?php echo __('History'); ?></button>
		</div>
		<?=
		$this->Format->actions([

			[ 'pencil', __('Edit'), [ C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey] ] ],

			$model->isDeletable()
				? [ 'trash-o', __('Delete'), [ C => $controller, A => 'delete', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn', 'confirm' => __('Are you sure you want to delete') . ":\n" . $record[$modelClass][$model->displayField] . ' ?' ] ]
				: null,

			$model->isCopyable()
				? [ 'copy', __('Create a copy'), [ C => $controller, A => 'copy', $record[$modelClass][$model->primaryKey] ] ]
				: null,

			$model->isAddable()
				? [ 'plus', __('Add new'), [ C => $controller, A => 'add' ] ]
				: null,

			$model->isListable()
				? [ 'list', __('List all'), [ C => $controller, A => 'index' ] ]
				: null
		])
		?>

	</div>

	<div class="<?= $plural ?> view with-sidebar">
		<?php

		# Uploads
		foreach ($model->hasOne as $association => $params) {
			if ($model->displayImage != $association) {
				$hasOne[__(Inflector::humanize($association))] = $this->Format->image($record[$association], 80, null, $association);
			}
		}

		# Main data
		foreach ($schema as $field => $schema)
			if (!in_array($field, array_merge($model->invisible, $skip))) {
				$langs = !empty($schema['polyglot'])
					? array_keys(Configure::read('Config.Languages'))
					: [ '' ];
				$values = [];
				foreach ($langs as $locale) {
					$value = isset($record[$modelClass][$field . '__'][$locale])
						? $record[$modelClass][$field . '__'][$locale]
						: $record[$modelClass][$field];

					# url
					if ($field == 'url') {
						$value = $this->Html->link($value, $value, [ 'target' => '_blank' ]);

						# _ID
					} else if (($id = substr($field, -3) == '_id') || (($var = Inflector::variable(Inflector::pluralize($field))) && isset($$var))) {

						if ($id) {
							$var = Inflector::variable(Inflector::pluralize(substr($field, 0, -3)));
						}
						$var = $$var;
						$value = isset($var[$value]) ? $var[$value] : null;

						# _SET
					} else if (substr($field, -4) == '_set') {
						$association = Inflector::camelize(substr($field, 0, -4));

					} else if ($field == $model->displayField) {
						$value = '<div class="view-title">' . $value . '</div>';

					} else {
						switch ($model->_schema[$field]['type']) {
							case 'boolean':
								$value = $this->Format->bool($record[$modelClass][$field]);
								break;
							case 'date':
								$value = $this->Format->time($value);
								break;
							case 'datetime':
								$value = $this->Format->time($value, true);
								break;
						}
					}
					$values[$locale] = trim((string) $value);
				}
				$list[$field] = $values;
			}

		# Echo
		echo '<div class="view-list view-overview">';
		echo '<dl class="list">';
		foreach ($list as $field => $description)
			if (empty($fieldOptions[$field]['hide'])) {
				$after = !empty($fieldOptions[$field]['after']) ? $fieldOptions[$field]['after'] : '';
				$before = !empty($fieldOptions[$field]['before']) ? $fieldOptions[$field]['before'] : '';
				if (!empty($fieldOptions[$field]['wrap'])) {
					$before .= $fieldOptions[$field]['wrap'];
					$after .= preg_replace('/<([a-z]+).*/', '</$1>', $before) . '<div class="clear"></div>';
				}
				if (!empty($fieldOptions[$field]['encode'])) {
					$description = preg_replace("/\n+/", "\n", htmlentities($description));
				}

				$fieldname = __(Inflector::humanize($field));

				foreach ($description as $locale => $value) {
					if (!empty($fieldOptions[$field]['pre']) || (isset($formOptions[$field]['rte']) && empty($formOptions[$field]['rte']))) {
						$value = $this->Html->tag('pre', htmlentities($value));
					}
					?>
					<dt class="list<?= !empty($locale) ? ' lang lang-' . $locale : '' ?>"<?= !empty($locale) && $locale != Configure::read('Config.language') ? ' style="display:none"' : '' ?> id="<?= $modelClass . Inflector::camelize($field) ?>"><?= $fieldname ?></dt>
					<dd class="list<?= !empty($locale) ? ' lang lang-' . $locale : '' ?>"<?= !empty($locale) && $locale != Configure::read('Config.language') ? ' style="display:none"' : '' ?> id="<?= $modelClass . Inflector::camelize($field) ?>"><?= $before . ($value !== '' ? $value : '&nbsp;') . $after ?></dd>
					<?php
				}
			}
		?>
		<dt class="list"><?= __('Commented on') ?></dt>
		<dd class="list">
			<?php
			$parentModel = ClassRegistry::init($record[$modelClass]['model']);
			$item = $parentModel->find('first', $record[$modelClass]['foreign_key']);
			$link = str_replace('admin.', '', FULL_BASE_URL);
			$link .= $this->Front->getModulePath($item);
			echo $this->Html->link($item[$parentModel->alias][$parentModel->displayField], $link, [ 'target' => '_blank' ]);
			?>
		</dd>
		<?php
		echo '</dl>';
		echo '<div class="clear"></div>';
		echo '</div>';
		?>

		<div class="view-list view-history" style="display:none">
			<?php
			if (empty($logHistory)) {
				echo __("No history for this item") . ".";
			} else {
				?>
				<h3 style="float:left;"><?php echo __("History"); ?></h3>
				<button id="expandBtn" type="button" class="btn pull-right" onclick="expandAllHistory()"><?php echo __('Expand all'); ?></button>
				<?php
				foreach ($logHistory as $log) {
					echo $this->Format->showLog($log, 'view');
				}
			}
			?>
			<div style="clear:both"></div>
		</div>
		</dl>
	</div>
	<script type="text/javascript">

		/* Select translation */
		$('.view-bar-section a.flag').click(function () {
			$('.lang').hide();
			$('.lang.lang-' + $(this).attr('rel')).show();
			$('.view-bar-section a.flag').removeClass('flagged');
			$(this).addClass('flagged');
		});

		/* Toggle more details */
		$('a.more-details').click(function () {
			$('.view-bar-more-details').fadeToggle();
			return false;
		});


		function toggleHistory(param) {
			$("div.view-list").hide();
			$("div.view-" + param).show();
		}


		function showDetails(id) {
			if ($(".log-history-item#history-item-" + id).is(":visible")) {
				$(".log-history-item#history-item-" + id).hide();
			} else {
				$(".log-history-item#history-item-" + id).fadeToggle('fast');

			}
		}

		function expandAllHistory() {
			var btnText = $("#expandBtn").text();

			if (btnText == '<?php echo __("Expand all");?>') {
				$(".log-history-item").show('fast');
				$("#expandBtn").text('<?php echo __("Collapse all");?>');
			} else {
				$(".log-history-item").hide('fast');
				$("#expandBtn").text('<?php echo __("Expand all");?>');
			}

		}

	</script>
<?php }
Timer::end('scaffold') ?>
