<?php

// Should the activity be shown
if (!Configure::read('Backend.dashboard_history')) {
	return;
}

$filled = true;

// Load
$list = [];
$logs = ClassRegistry::init('Log')->getLatest();
foreach ($logs as $i => $log) {
	$entry = [];

	// Make sure this is a module
	$module = ClassRegistry::init('Module')->find('first', [
		'recursive'  => -1,
		'fields'     => [ 'name', 'icon', 'use_table' ],
		'conditions' => [
			'Module.name' => $log['Log']['model'] ]
	]);

	// Skip for non-module model
	if (!$module) {
		continue;
	}

	// Get record info
	$model = ClassRegistry::init($module['Module']['name']);
	$name = $model->field($model->displayField, [ 'id' => $log['Log']['foreign_key'] ]);
	if (!$name) {
		$name = '<i> - empty - </i>';
	}

	// Get the icon for the edit type (insert, update or delete)
	$type = [ 'question', __('Unknown') ];
	switch ($log['Log']['type']) {
		case'insert':
			$type = [ 'plus', __('Created'), '#666' ];
			break;
		case'update':
			$type = [ 'plus', __('Modified'), '#666' ];
			break;
		case'delete':
			$type = [ 'trash-o', __('Deleted'), '#E6B5B5' ];
			break;
	}

	// Details: Log
	$entry['log'] = [
		'time' => strtotime($log['Log']['created']),
		'link' => [ C => $module['Module']['use_table'], A => 'view', $log['Log']['foreign_key'], '#' => "history-{$log['Log']['id']}" ]
	];

	// Details: Module
	$entry['module'] = [
		'name' => $module['Module']['name'],
		'icon' => $module['Module']['icon'],
		'link' => [ C => $module['Module']['use_table'], A => 'index' ]
	];

	// Details: Module record
	$entry['record'] = [
		'name' => $name,
		'type' => $type,
		'link' => [ C => $module['Module']['use_table'], A => 'edit', $log['Log']['foreign_key'] ]
	];

	// Details: Administrator
	$entry['administrator'] = empty($log['Administrator']) ? null : [
		'name' => $log['Administrator']['full_name'],
		'link' => [ C => 'administrators', A => 'view', $log['Administrator']['id'] ]
	];

	$list[] = $entry;
}

?>

<div class="block">
	<h2><i class="fa fa-fw fa-history"></i><?= __('CMS log') ?></h2>

	<table class="main-table-index" style="border: none; margin-bottom: 0;">
		<tbody>
		<?php foreach ($list as $entry) { ?>
			<tr>
				<td width="20">
					<span class="fa-stack fa-lg">
						<i class="fa fa-stack-2x fa-square" style="color: #ddd;"></i>
						<i class="fa fa-stack-1x fa-<?= $entry['module']['icon'] ?>"></i>
					</span>
				</td>
				<td width="250" class="title">
					<?= $this->Html->link("{$entry['module']['name']}", $entry['module']['link']) ?>
				</td>
				<td width="*" class="title">
					<i class="fa fa-fw button fa-<?= $entry['record']['type'][0] ?>" style="color: <?= $entry['record']['type'][2] ?>;" title="<?= $entry['record']['type'][1] ?>"></i>
					<?= $this->Html->link($entry['record']['name'], $entry['record']['link']) ?>
				</td>
				<td width="160" align="center">
					<?php if ($entry['administrator']) { ?>
						<?= $this->Html->link($entry['administrator']['name'], $entry['administrator']['link']) ?>
					<?php } else { ?>
						-
					<?php } ?>
				</td>
				<td width="160" align="center">
					<p><?= $this->Html->link(date('d. M Y.', $entry['log']['time']) . '<br />' . date('H:i', $entry['log']['time']), $entry['log']['link']) ?></p>
				</td>
			</tr>
		<?php } ?>
		</tbody>
	</table>
</div>
