<?php
/**
 * SQL Dump element.  Dumps out SQL log information
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright        Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link             http://cakephp.org CakePHP(tm) Project
 * @package          cake
 * @subpackage       cake.cake.libs.view.templates.elements
 * @since            CakePHP(tm) v 1.3
 * @license          MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
if (!class_exists('ConnectionManager') || Configure::read('debug') < 2 || Configure::read('isAjax')) {
	return false;
}
?>

<!-- MySQL queries ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<style>
	table.cake-sql-log { border: 1px solid #7B91A4; width: 100%; }
	table.cake-sql-log caption { background: #7B91A4; font: normal 11px Verdana; color: white; border: 1px solid #777; padding: 3px 13px 4px; text-align: left; }
	table.cake-sql-log th { background: #7B91A4; color: white; font: normal 11px Verdana; padding: 3px 0; border-bottom: 1px solid #647B8E; }
	table.cake-sql-log th.i { width: 40px; }
	table.cake-sql-log th.query { }
	table.cake-sql-log th.error { }
	table.cake-sql-log th.affected { width: 40px; }
	table.cake-sql-log th.numRows { width: 40px; }
	table.cake-sql-log th.took { width: 105px; }
	table.cake-sql-log tr td { background: #fff; }
	table.cake-sql-log tr:nth-child(2n) td { background: #E9E9E9; }
	table.cake-sql-log td { font: normal 15px/20px Courier; vertical-align: middle; }
	table.cake-sql-log td.i { text-align: right; color: #777; width: 18px; }
	table.cake-sql-log td.query { text-align: left; padding: 4px 8px; }
	table.cake-sql-log td.query span { color: #800; }
	table.cake-sql-log td.query em { display: inline-block; width: 100%; font-style: italic; margin: 2px 0 4px; padding: 3px 8px; color: #777; }
	table.cake-sql-log td.query b { line-height: 51%; }
	table.cake-sql-log td.error { color: red; }
	table.cake-sql-log td.affected { text-align: center; }
	table.cake-sql-log td.numRows { text-align: center; color: #777; width: 30px; }
	table.cake-sql-log td.took { text-align: right; padding-right: 2em; width: 70px; }
</style>

<br />

<div class="row">
	<div class="col-xs-12">

		<?php
		$noLogs = !isset($logs);
		if ($noLogs) {
			$sources = ConnectionManager::sourceList();

			$logs = [];
			foreach ($sources as $source) {
				$db = ConnectionManager::getDataSource($source);
				$logs[$source] = $db->getLog(false, false);
			}
		}

		if (!empty($logs) || isset($_forced_from_dbo_)) {

			$starters = implode('|', [ 'SELECT' ]);
			$spliters = implode('|', [ 'WHERE', 'ORDER BY', 'FROM', 'INNER', 'LEFT', 'LIMIT', 'GROUP', 'SET', 'INSERT INTO', 'VALUES', 'UPDATE', 'DELETE', 'ALTER', 'DROP', 'ON DUPLICATE KEY' ]);

			foreach ($logs as $source => $logInfo) {
				$text = $logInfo['count'] > 1 || empty($logInfo['count']) ? 'queries' : 'query';
				printf(
					'<table class="cake-sql-log" id="cakeSqlLog_%s" summary="Cake SQL Log" cellspacing="0" border = "0">',
					preg_replace('/[^A-Za-z0-9_]/', '_', uniqid(time(), true))
				);
				printf('<caption>%s %s took a total of %d ms</caption>', $logInfo['count'], $text, $logInfo['time']);
				?>
				<tbody>
				<?php $i = 0;
				foreach ($logInfo['log'] as $log) {
					$query = $log['query'];

					# Skip common CakePHP queries
					if (strpos($log['query'], 'ON DUPLICATE KEY') || in_array(substr($log['query'], 0, 17), [ 'SHOW FULL COLUMNS', 'SELECT CHARACTER_' ]))
						continue;

					# Get fields from select
					$title = null;
					preg_match('~^\s*SELECT\s+(.*)\s+FROM~ sim', $query, $fields);
					if(!empty($fields[1])) {
						$title = implode('` \n', (preg_split('~`\s*,\s*~', $fields[1])));
					}

					# Add spaces between each query section
					$query = preg_replace("~(^|\s+)({$spliters})~", "<br /><span>$2</span>", $query);

					# Divide starters from the rest of the query
					$query = preg_replace("~\s*({$starters})(\s.*)\<br /\>~ isU", '<span>$1</span>$2<br /><b><br /></b>', $query);

					# Format the starting comment
					$query = preg_replace('~^\s*(--\s+.*--)~', '<em>$1</em>', $query);

					# Transaction
					$query = preg_replace('~^\s*(begin|commit|rollback)\s*$~ i', '<strong>$0</strong>', $query);

					# WHERE
					$query = preg_replace('~ (AND|OR) ([\'"`\(])~', " \$1<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\$2", $query);

					# Trim
					if (substr($query, 0, 6) == '<br />')
						$query = substr($query, 6);

					?>

					<tr>
						<td class="i"><?php echo $i + 1 ?></td>
						<td class="query"<?php echo $title ? " title=\"{$title}\"" : '' ?><?php echo !empty($log['numRows']) ? ' class="error"' : '' ?>><?php echo trim($query) ?></td>
						<td class="numRows"><?php echo $log['numRows'] ?></td>
						<td class="took"><?php echo $log['took'] ?>ms</td>
					</tr>
					<?php $i++;
				} ?>

				</tbody>
				</table>
				<?php
			}

			# On error
		} else {
			echo '<p>Encountered unexpected $logs cannot generate SQL log.</p>';
		}

		?>
	</div>
</div>
