<?php
	if(empty($template) || !is_array($template)) return;

	# If we are making copy, set new id for blocks
	$copy = !empty($this->request->params['copy']) ? 'c' : '';
	$i = $copy . $i;

	# Input types for block type
	$typeMap = array(
		'string' => 'text',
		'text' => 'textarea',
		'custom' => 'textarea',
		'richtext' => 'textarea',
		'image' => 'text'
	);

	# Remove button
	$remove = $this->Html->link(__('X'), 'javascript: void(0)', array('class' => 'content-template-remove', 'onclick' => ''));

	# Meta fields
	$meta  = $this->Form->hidden("Content.{$i}.id", array('value' => $template['Content']['id']));
	$meta .= $this->Form->hidden("Content.{$i}.template_id", array('value' => $template['Content']['template_id']));
	$meta .= $this->Form->hidden("Content.{$i}.locale", array('value' => $language['Language']['locale']));
	$meta .= $this->Form->hidden("Content.{$i}.field", array('value' => $field));

	# Templates
	$items = array();
	if(!empty($template['Blocks'])) {
		foreach($template['Blocks'] as $name => $block) if(!empty($block['type'])) {

			# Block itself
			$items[] = $this->Form->input(
				"Content.{$i}.Blocks.{$name}",
				array(
					'label' => sizeof($template['Blocks']) > 1 ? __(Inflector::humanize($block['name'])) : false,
					'value' => $block['content'],
					'type' => $typeMap[$block['type']],
					'class' => $block['type'] == 'richtext' ? 'rte' : null)
			);
		}
	}
?>

<li class="content-template<?= !$template['Content']['id'] ? ' content-template-new' : '' ?>">

	<label>
		<a href="javascript: void(0)" onclick="$(this).closest('li').remove()" class="content-template-remove">X</a>
		<div class="content-template-name"><?= __(Inflector::humanize($template['Template']['name'])) . ($isSuperadmin ? " ({$template['Template']['id']})" : null) ?></div>

		<?php if(!empty($template['Template']['description'])) { ?>
			<div class="content-template-description"><?= $template['Template']['description'] ?></div>
		<?php } ?>

		<?php if(!empty($language['Icon']['file'])) { ?>
			<?= $this->Html->image($language['Icon']['file']) ?>
		<?php } ?>
	</label>

	<?= $meta ?>
	<?= implode($items) ?>

	<div class="clear"></div>
</li>
