<?php
	ob_start();

	# Make sure we have the model
	if(!isset($model)) {
		$model = ClassRegistry::init($modelClass);
	}
?>
<div class="header<?= !empty($showSidebar) ? ' with-sidebar' : null ?>">

	<?php
		$edit = !empty($this->request->data[$modelClass][$model->primaryKey]);

		echo $this->Format->actions($actions = array(

			# Edit original
			!empty($copy)
				? array('pencil', __('Edit the original'), array(C => $controller, A => 'edit', $copy))
				: null,

			# Details
			$edit
				? array('eye', __('Details'), array(C => $controller, A => 'view', $this->request->data[$modelClass][$model->primaryKey]))
				: null,

			# Delete
			$edit  && $model->isDeletable($this->request->data[$modelClass][$model->primaryKey])
				? array('trash-o', __('Delete'), array(C => $controller, A => 'delete', $this->request->data[$modelClass][$model->primaryKey]), array('class' => 'btn', 'confirm' => __('Are you sure you want to delete') . "\\n" . $this->request->data[$modelClass][$model->displayField] . ' ?'))
				: null,

			# Create a copy
			$edit  && $model->isCopyable($this->request->data[$modelClass][$model->primaryKey])
				? array('copy', __('Create a copy'), array(C => $controller, A => 'copy', $this->request->data[$modelClass][$model->primaryKey]))
				: null,

			# Create new
		   $edit  && $model->isAddable()
				? array('plus', __('Add new'), array(C => $controller, A => 'add'))
				: null,

			# List all records
			$model->isListable()
				? array('list', __('List all'), array(C => $controller, A => 'index'))
				: null
		));
	?>
</div>

<?php

	# If there are no actions, do not show anything
	$header = ob_get_clean();
	foreach($actions as $action) if($action) {
		echo $header;
		break;
	}
?>
