<div class="metatags">
	<?php
		$generators = array();
		if(in_array('Seo', App::objects('plugin'))) {
			$generatorsDir = App::pluginPath('Seo') . 'Model' . DS . 'MetaGenerators' . DS . 'Generators' . DS;
			$files = scandir($generatorsDir);
			foreach($files as $model) {
				if(in_array($model, array('..', '.'))) continue;

				# Get available generators
				$model = str_replace('.php', '', $model);
				$generation = str_replace("Seo", '',str_replace("Generation", '', $model));
				$generators[$generation] = $generation;
			}
		}

		$custom = false;
		$generated = false;
		$polyglot = true;
		$page = true;

		$fields = array(
			'title' => 'meta_title',
			'image' => 'MetaImage',
			'keywords' => 'meta_keywords',
			'description' => 'meta_description');

		if(isset($modelClass) && !in_array($modelClass, array('Page'))) {
			$page = false;
			$fields['keywords'] = 'meta_keyword';
		}
		if(!isset($this->data[$modelClass]['meta'])) {
			$custom = false;
			$generated = false;
		} elseif(empty($this->data[$modelClass]['meta'])) {
			$custom = true;
			$generated = false;
		} elseif($this->data[$modelClass]['meta'] != null) {
			$custom = false;
			$generated = true;
		}

		if(!isset($this->data[$modelClass]['id']) && !$custom) {
			$generated = true;
		}

		# Set generation for form
		if(isset($this->request->data[$modelClass]['meta'])) {
			$this->request->data[$modelClass]['generation'] = $this->request->data[$modelClass]['meta'];
		}

		if(count(Configure::read('Config.Languages')) == 1 && !$page) $polyglot = false;
		$func = $polyglot ? 'polyglots' : 'input';

		# For displaying correct model and its value on the next tab
		$this->Form->hidden('dummy');

	?>

	<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true" style="margin-top:20px">
		<div class="panel panel-default">
			<div class="panel-heading" role="tab" id="seoMetatags">
				<h4 class="panel-title">
					<a data-toggle="collapse" data-parent="#accordion" href="#seoMetatagsAria" aria-expanded="true" aria-controls="collapseOne">
						<?= __('Meta tags settings') ?>
					</a>
				</h4>
			</div>
			<div id="seoMetatagsAria" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="seoMetatags">
				<div class="panel-body">
					<?= $this->element('form/meta/meta_generators', compact('custom', 'generated', 'func', 'generators', 'page', 'fields')) ?>
					<div class="clear"></div>

					<hr class="thin-hr"/>

					<h3 class="h4"><?= __('Additional Metatags') ?></h3>
					<?= $this->element('form/meta/meta_config', compact('custom', 'generated', 'func', 'generators', 'page', 'fields')) ?>
				</div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading" role="tab" id="headingOne">
				<h4 class="panel-title">
					<a data-toggle="collapse" data-parent="#accordion" href="#seoUrlSettings" aria-expanded="true" aria-controls="collapseOne">
						<?= __('Url Settings') ?>
					</a>
				</h4>
			</div>
			<div id="seoUrlSettings" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
				<div class="panel-body">
					<?php
						echo $this->Form->polyglots('overriden_slug', array('label' => __('Url Fragment')));
					?>
				</div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading" role="tab" id="headingOne">
				<h4 class="panel-title">
					<a data-toggle="collapse" data-parent="#accordion" href="#seoSitemapSettings" aria-expanded="true" aria-controls="collapseOne">
						<?= __('Sitemap Settings') ?>
					</a>
				</h4>
			</div>
			<div id="seoSitemapSettings" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
				<div class="panel-body">
					<?php
						echo $this->Form->input('change_frequency');
						echo $this->Form->input('priority');
					?>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading" role="tab" id="seoAdditionalCode">
				<h4 class="panel-title">
					<a data-toggle="collapse" data-parent="#accordion" href="#seoAdditionalCodeAria" aria-expanded="true" aria-controls="collapseOne">
						<?= __('Additional code') ?>
					</a>
				</h4>
			</div>
			<div id="seoAdditionalCodeAria" class="panel-collapse collapse" role="tabpanel" aria-labelledby="seoAdditionalCode">
				<div class="panel-body">
					<?php
						echo $this->Form->input('head_end', array('type' => 'textarea'));
						echo $this->Form->input('body_start', array('type' => 'textarea'));
						echo $this->Form->input('body_end', array('type' => 'textarea'));
					?>
				</div>
			</div>
		</div>
	</div>
</div>
