<?php
$metaTags = ClassRegistry::init('Seo.MetaTag')->getAllById();
$listMetaTags = ClassRegistry::init('Seo.MetaTag')->getForList([ 'is_visible' => true ]);
?>

<div class="meta-tags-config">
	<div>
		<a href="javascript:void(0)" class="btn btn-small btn-success btn-new-additional-tag">
			<i class="fa fa-fw fa-plus">&nbsp;</i><?= __('Add new') ?>
		</a>
	</div>

	<div class="additional-metatags-list">
		<div class="row"></div>
	</div>
	<div class="clear"></div>
	<p class="text-center no-items-flag" style="display:nones">
		<i><?= __('No additional meta tags') ?></i>
	</p>

	<div class="templates" style="display:none">
		<div class="additional-metatag col-sm-6">
			<div class="additional-metatag-wrapper clearfix">
				<a href="javascript:void(0)" class="btn btn-sm btn-danger btn-icon-only btn-remove-additional-tag"><i class="fa fa-fw fa-close"></i></a>
				<div class="col-sm-12">
					<?= $this->Form->input('Seo.temp-meta-tag', [ 'type' => 'select', 'options' => $listMetaTags, 'label' => __('Name'), 'data-name' => 'meta-tag-###value###', 'class' => 'meta-tag-type' ]); ?>
				</div>
				<div class="col-sm-12 meta-tag-value">
					<div class="value-group value-text">
						<?= $this->Form->polyglots('Seo.temp-value', [ 'type' => 'text', 'label' => __('Value'), 'data-name' => 'value-###value###' ]); ?>
					</div>

					<div class="value-group value-textarea">
						<?= $this->Form->polyglots('Seo.temp-value', [ 'type' => 'textarea', 'label' => __('Value'), 'data-name' => 'value-###value###' ]); ?>
					</div>

					<div class="value-group value-select">
						<?= $this->Form->polyglots('Seo.temp-value', [ 'type' => 'select', 'options' => [], 'label' => __('Value'), 'data-name' => 'value-###value###' ]); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<style>
	.meta-tags-config .added-tags-list .list-holder {
		margin-bottom: 30px;
	}
	.additional-metatags-list { padding: 20px 0; }
	.meta-tags-config .additional-metatags-list .additional-metatag-wrapper {
		position: relative;
		margin: 5px 0;
		border: 2px solid #999999;
		padding: 5px;
		border-radius: 3px;
		background: #F0F0F0;
	}
	.meta-tags-config .additional-metatags-list .additional-metatag .btn-remove-additional-tag {
		position: absolute;
		right: 0;
		top: 0;
		z-index: 10000;
	}
	.meta-tags-config .additional-metatags-list .additional-metatag .value-group {
		display: none;
	}
</style>

<script type="text/javascript">
	$(document).ready(function () {

		function AdditionalMetatagsHelper(wrapper, tags) {
			var $this = this,
				$wrapper = $(wrapper);
			$tags = tags;

			var $init = function () {
				$backupInputNames();
				$attachListeners();
			};

			var $attachListeners = function () {
				$wrapper.find('.btn-new-additional-tag').click(function () {
					$appendNewTag();
				});
			};


			var $backupInputNames = function () {
				$wrapper.find('.additional-metatag :input').each(function (index, input) {
					$(input).attr('data-name', $(input).attr('name'));
					$(input).removeAttr('name');
				});
			};


			var $appendNewTag = function (data) {
				var $template = $('.templates .additional-metatag').clone();

				// Remove already selected items
				$template = $clearExistingTags($template);

				if (!$template) {
					alert('You used all tags');
					return;
				}

				$template.find('.btn-remove-additional-tag').click(function () {
					$removeExistingTag($template);
				});

				$template.find('.meta-tag-type').hover(function (e) {
					$(this).data('prev-value', $(this).val());
				});
				$template.find('.meta-tag-type').change(function (e) {
					var changeSuccess = $handleTypeChange($template);

					if (!changeSuccess) {
						$(this).val($(this).data('prev-value'));
					}

				});
				$template.find('.meta-tag-type').trigger('change');

				if (data) {
					$applyData($template, data);
				}

				$template.hide();
				$wrapper.find('.additional-metatags-list .row').append($template);
				$template.fadeIn(150);
				$triggerListChanged();
			};

			this.appendNewTag = $appendNewTag;


			var $removeExistingTag = function ($template) {
				if (confirm('Are you sure?')) {
					// Remove template
					$template.fadeOut(150, function () {
						$template.remove();
						$triggerListChanged();
					});
				}
			};

			var $triggerListChanged = function () {
				var tagsCount = $wrapper.find('.additional-metatags-list .additional-metatag').length;

				if (tagsCount > 0) {
					$wrapper.find('.no-items-flag').hide();
				} else {
					$wrapper.find('.no-items-flag').show();
				}
			};


			// Clear existing items
			var $clearExistingTags = function ($template) {
				var $select = $template.find('select.meta-tag-type');

				// Get all selected
				var selected = [];
				$.each($wrapper.find('select.meta-tag-type'), function (index, type) {
					var $type = $(type);
					selected.push($type.val());
				});

				$.each(selected, function (index, sel) {
					$select.find('option[value="' + sel + '"]').remove();
				});

				if ($select.find('option').length == 0) {
					return false;
				}

				return $template;
			};


			// Handle type change
			var $handleTypeChange = function ($template) {
				var $select = $template.find('.meta-tag-type');

				// Check if there is select with same value
				var isAllowed = $checkChange($select);
				if (!isAllowed) {
					alert('You alredy added this tag');
					return false;
				}

				var selectedTag = $tags[$select.val()];

				$template.find('.meta-tag-value :input').each(function () {
					$(this).removeAttr('name');
				});

				switch (selectedTag.value_type) {
					case 'text':
						$parseMetatagField($template.find('.value-text'), selectedTag);
						break;
					case 'textarea':
						$parseMetatagField($template.find('.value-textarea'), selectedTag);
						break;
					case 'select':
						$parseMetatagField($template.find('value-select'), selectedTag);
						break;
				}

				return true;

			};

			// Check if current select value is duplicated
			var $checkChange = function ($select) {
				var checkValue = $select.val();
				var valid = true;

				// Find select with same value
				$wrapper.find('select.meta-tag-type').each(function () {
					if ($(this).val() == checkValue && !$(this).is($select)) {
						valid = false;
						return false;
					}
				});

				return valid;
			};


			var $parseMetatagField = function ($fieldWrapper, selectedTag) {
				// Show this field
				$fieldWrapper.show();

				$fieldWrapper.find(':input').each(function (index, input) {
					$(input).attr('name', $(input).attr('data-name').replace('temp-value__', 'metatag][' + selectedTag.id + ']['));
				});
				//~ $field.attr('name', 'data[Seo][meta-tag][' + selectedTag.id + ']');
			};

			// Apply supplied data to template
			var $applyData = function ($template, data) {
				// Set type id
				$template.find('.meta-tag-type').val(data.id);
				// Trigger change to show proper field
				$template.find('.meta-tag-type').trigger('change');
				$template.find('.meta-tag-value :input').each(function () {
					var locale = $(this).attr('rel').slice(-2);
					$(this).val(data.values[locale]);
				});
			};

			$init();
		}

		$(document).ready(function () {
			var additionalMetatags = new AdditionalMetatagsHelper('div.meta-tags-config', <?= json_encode($metaTags) ?>);

			<?php if(isset($this->request->data['Seo']['metatag'])) { ?>
			<?php foreach($this->request->data['Seo']['metatag'] as $id => $values) { ?>
			additionalMetatags.appendNewTag(<?= json_encode([ 'id' => $id, 'values' => $values ]) ?>);
			<?php } ?>
			<?php } ?>
		});
	});
</script>
