<?php

/**
 * @var string $controller The current controller.
 */

if (!Configure::read('Feature.export_allowed') || empty($records) || !$model->exportEnabled) {
	return;
}

// Define the list of available formats
$formats = [
	'csv'  => __('CSV'),
	'xml'  => __('XML'),
	'json' => __('JSON'),
	'xlsx' => __('Excel')
];

?>

<li class="btn-group">
	<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
		<i class="fa fa-fw fa-external-link fa-level-down"></i>
		<?= __('Export') ?>
		&nbsp;
		<span class="caret"></span>
	</button>

	<ul class="dropdown-menu">
		<?php foreach ($formats as $format => $name) { ?>
			<li>
				<?= $this->Html->link(__($name), [ P => null, C => $controller, A => 'index', '?' => [ 'export' => $format ] ]) ?>
			</li>
		<?php } ?>
	</ul>
</li>
