<?php ob_start() ?>
<ul class="sortable"<?= empty($level) ? ' id="treesort"' : '' ?>>
	<?php
	foreach ($tree as $node) {
		$children = !empty($node['children'])
			? $this->element('index/sort_tree', [ 'tree' => $node['children'], 'level' => isset($level) ? $level + 1 : 1 ])
			: '';
		echo $this->Html->tag('li', $node[$modelClass][$displayField] . $children, [ 'rel' => $node[$modelClass]['id'] ]);
	}
	?>
</ul>
<?php
$list = ob_get_clean();
if (!empty($level)) {
	echo $list;
	return;
}
?>

<div id="SortTreeModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">
					×
				</button>
				<h4><?= __('Sorting') ?></h4>
			</div>

			<div class="modal-body">
				<?= $list ?>
				<script type="text/javascript">
					var delta = 0;
					$(function () {

						$('#SortTreeModal').on('hide', function () {
							location.reload();
						});

						$('.sortable').sortable({
							placeholder: 'placeholder',
							forcePlaceholderSize: true,
							start: function (event, ui) {
								delta = $(ui.item).nextAll().length;
							},
							stop: function (event, ui) {
								delta = delta - $(ui.item).nextAll().length - 1;
								if (delta != 0) {
									$.get('<?= $this->Html->url([ C => $controller, A => 'sort_tree' ]) ?>/' + $(ui.item).attr('rel') + '/' + delta);
								}
							}
						});
						$("#treesort").treeview();
					});
				</script>
			</div>

			<div class="modal-footer">
				<button class="btn btn-primary" data-dismiss="modal"><?= __('Save and close') ?></button>
			</div>
		</div>
	</div>
</div>
