<?php

/**
 * @var string $modelClass The name of the model which is being currently shown.
 * @var array  $crumbs     Breadcrumbs that point to the current location, relative to the home.
 * @var array  $bookmarks  The list of user defined bookmarks.
 */

// Helpful variables
$caret = '<b class="caret"></b>';
$attributes = [ 'class' => 'dropdown-toggle', 'data-toggle' => 'dropdown' ];
?>

<?php if (!empty($administrator) && is_array($administrator)) { ?>

	<header role="banner">
		<div class="top clearfix">
			<nav>
				<ul>
					<?= $this->element('layout/menu') ?>
				</ul>
			</nav>

			<div class="profile pull-right">

				<ul class="pull-right">
					<?php if (!empty($isSuperadmin)) { ?>

						<?php if ($errors = @file_get_contents(LOGS . 'error.log') || @file_get_contents(LOGS . 'debug.log')) { ?>
							<li>
								<?= $this->Html->link('<i class="fa fa-fw fa-warning"></i>', [ P => null, C => 'logs', A => 'system' ], [ 'class' => 'errors', 'title' => __('There are logged errors waiting for your review') ]) ?>
							</li>
						<?php } ?>

						<li class="dropdown">
							<?= $this->Html->link(__('Admin Tools') . $caret, '#AdminTools', array_merge($attributes, [ 'class' => 'admin' ])) ?>
							<ul class="dropdown-menu pull-right columns admin-tools">

								<li class="dropdown-header"><?= __('Configuration') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-sliders"></i>' . __('Settings'), [ P => null, C => 'configs', A => 'index' ], 'settings') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-globe"></i>' . __('Languages'), [ P => null, C => 'languages', A => 'index' ], 'languages') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-paint-brush"></i>' . __('Theme'), [ P => null, C => 'theme', A => 'index' ], 'theme') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-group"></i>' . __('Administrators'), [ P => null, C => 'administrators', A => 'index' ], 'users') ?></li>

								<li class="divider"></li>
								<li class="dropdown-header"><?= __('Info') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-info"></i>' . __('phpinfo()'), [ P => null, C => 'tools', A => 'phpinfo' ], 'phpinfo') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-trophy"></i>' . __('CMS version'), [ P => null, C => 'tools', A => 'version' ], 'version') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-envelope-o"></i>' . __('Email render test'), [ P => null, C => 'tools', A => 'renderEmails' ], 'email') ?></li>

								<li class="divider"></li>
								<li class="dropdown-header"><?= __('Tools') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-flash"></i>' . __('Push notifications'), [ P => null, C => 'tools', A => 'push' ], 'push') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-code"></i>' . __('Cronner'), [ P => 'cronner', C => 'cronnerDashboard', A => 'index' ], 'cron') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-magic"></i>' . __('Module Manager'), [ P => null, C => 'modules', A => 'index' ], 'modules') ?></li>

								<li class="dropdown-header"><?= __('Maintenance') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-ban"></i>' . __('Clear cache'), [ P => null, C => 'tools', A => 'clear' ], 'cache') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-picture-o"></i>' . __('Repair Image Cache'), [ P => null, C => 'tools', A => 'repairImages', $modelClass ], 'repair') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-medkit"></i>' . __('Repair table'), [ P => null, C => 'tools', A => 'repair', $modelClass ], 'repair') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-lock"></i>' . __('Refresh aco'), [ P => null, C => 'tools', A => 'acl' ], 'acl') ?></li>

								<li class="divider"></li>
								<li class="dropdown-header"><?= __('Logs') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-align-left"></i>' . __('API log'), [ P => null, C => 'log_apis', A => 'index' ], 'log-api') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-align-justify"></i>' . __('Usage log'), [ P => null, C => 'logs', A => 'usage' ], 'log-usage') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-list"></i>' . __('System log'), [ P => null, C => 'logs', A => 'system' ], 'log-system') ?></li>

								<li class="divider"></li>
								<li class="dropdown-header"><?= __('Database') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-database"></i>' . __('phpMyAdmin'), [ P => null, C => 'tools', A => 'phpMyAdmin' ], 'database') ?></li>
								<li><?= $this->Html->link('<i class="fa fa-fw fa-download"></i>' . __('Database dump'), [ P => null, C => 'tools', A => 'dump' ], 'dump', __('Create and download MySQL dump file?')) ?></li>
								<?php if (in_array($this->request->params[C], Set::extract('/Module/use_table', Stash::read('modules')))) { ?>
									<li><?= $this->Html->link('<i class="fa fa-fw fa-play-circle"></i>' . __('Populate module'), [ C => $this->request->params['controller'], A => 'populate', '14' ], 'populate') ?></li>
								<?php } else { ?>
									<li class="empty">&nbsp;</li>
								<?php } ?>

							</ul>
						</li>
					<?php } ?>

					<li class="avatar">
						<?php

						# Show name
						$username = $administrator['Administrator']['group_id'] != 0 ? $administrator['Administrator']['full_name'] : null;

						# Define avatar
						$avatar = '<span></span>' . $this->Manicure->match(!empty($administrator['Photo']['file']) ? $administrator['Photo'] : Theme::asset('login.png'), 34, 34, false);

						# Define flag
						$flag = '';
						if (sizeof(Configure::read('Config.Languages')) > 1) {
							$flag = !empty(Configure::read("Config.Languages.{$locale}.Icon.file"))
								? $this->Html->image(Configure::read("Config.Languages.{$locale}.Icon.file"), [ 'class' => 'flag' ])
								: '<i class="flag">' . Configure::read("Config.Languages.{$locale}.Language.locale") . '</i>';
						}

						# Draw
						echo $this->Html->link(
							$username . '<div class="img">' . $avatar . '</div>' . $flag,
							'javascript:void(0)',
							[ 'class' => 'sb-toggle-right pull-right' ]
						)
						?>
					</li>
				</ul>
			</div>

			<a href="javascript:void(0)" class="fa fa-bars responsive-toggle sb-toggle-left"></a>
		</div>

		<div class="subheader">
			<ul class="breadcrumb">
				<li><a href="/"><?= __('Dashboard') ?></a></li>
				<?php foreach (array_values($crumbs) as $i => $crumb) { ?>
					<li class="<?= !isset($crumbs[$i + 1]) ? 'active' : null ?>">
						<?= is_array($crumb) ? $this->Html->link($crumb[0], $crumb[1]) : $crumb ?>
					</li>
				<?php } ?>
			</ul>

			<ul class="breadcrumb bookmarks">
				<?php foreach ($bookmarks as $name => $url) { ?>
					<li>
						<?= $this->Html->link($name, $url) ?>
					</li>
				<?php } ?>

				<li>
					<?=
					$this->Html->link(
						'<i class="fa fa-fw fa-star-o"></i>',
						[ P => null, C => 'bookmarks', A => 'form', str_replace('/', '|', $this->here) ],
						[
							'escape' => false,
							'title'  => __('Click to bookmark this page') ]
					)
					?>
				</li>
			</ul>
		</div>
	</header>
<?php } ?>
