<?php
	if (empty($administrator)) {
		return;
	}
?>

<div style="position: relative; z-index:0;">
	<img src="/img/leaves_top.png" class="top-leaves" style="position: absolute; width: 30%;">
</div>

<div id="SideProfileInfo" class="profile">
	<div class="avatar forms-avatar">

		<div class="log-out pull-right">
			<i class="fa fa-lock"></i><?= $this->Html->link(__('sign out'), [ C => 'administrators', A => 'logout' ], [ 'title' => __('Click to sign out of VectorCMS') ]) ?>
		</div>

		<div class="profile-img clearfix">
			<div class="wrapper" style="padding: 5px 0;">
				<?= $this->Manicure->match(!empty($administrator['Photo']['file']) ? $administrator['Photo'] : Theme::asset('login.png'), 200, 200, false) ?>
			</div>
			<h3><?= $administrator['Administrator']['full_name'] ?></h3>
			<p><?= $administrator['Administrator']['email'] ?></p>

			<div class="clear"></div>
		</div>
	</div>

	<div class="profile-actions">
		<?= $this->Html->link('<i class="fa fa-fw fa-pencil"></i>' . __('Edit profile'), '#SideProfileForm', [ 'class' => 'btn btn-default profile-edit' ]) ?>
		<?= $this->Html->link('<i class="fa fa-fw fa-lock"></i>' . __('Change password'), '#SidePasswordForm', [ 'class' => 'btn btn-default pull-right profile-edit' ]) ?>
	</div>
</div>

<div class="forms" style="position: relative; z-index:1;">
	<form id="SidePasswordForm" style="display:none" class="side-profile-form" enctype="multipart/form-data">
		<h3><?= __('Password change') ?></h3>

		<label for="NewPassword"><?= __('Your new password') ?></label>
		<input id="NewPassword" name="data[Administrator][new_password]" data-password="password" />

		<label for="NewPassword"><?= __('Confirm your new password') ?></label>
		<input id="NewPasswordAgain" name="data[Administrator][new_password_again]" data-password="password" />

		<div class="options">
			<a class="btn close-form" href="javascript:void(0)"><?= __('Cancel') ?></a>
			<button type="submit" class="btn btn-success"><?= __('Change password') ?></button>
			<img src="/img/ico/loader_small.gif" class="loader" />
		</div>
	</form>

	<form id="SideProfileForm" style="display:none" class="side-profile-form" method="post" enctype="multipart/form-data" action="/sr/my_profile">
		<h3><?= __('Profile change') ?></h3>
		<div class="profile-img clearfix">
			<label for="PhotoNewFile" id="PhotoNewFileLabel">
				<div class="wrapper">
					<?= $this->Manicure->match(!empty($administrator['Photo']['file']) ? $administrator['Photo'] : Theme::asset('login.png'), 200, 200, false) ?>

					<div class="overlay" data-upload-behaviour="working">
						<img src="/img/ico/loader_medium.gif" />
					</div>

				</div>

				<div class="state">
					<p data-upload-behaviour="idle">
						<?= __('click here to change your profile picture') ?><br />
						<?= __('or drag and drop your new image') ?>
					</p>
					<span class="bar" data-upload-behaviour="working">&nbsp;</span>
				</div>
			</label>
		</div>

		<div class="input">
			<label for="YourName"><?= __('Your Name') ?></label>
			<input id="YourName" name="data[Administrator][full_name]" type="text" value="<?= $administrator['Administrator']['full_name'] ?>" class="input" />
		</div>

		<div class="input">
			<label for="YourEmail"><?= __('Your Email') ?></label>
			<input id="YourEmail" name="data[Administrator][email]" type="text" value="<?= $administrator['Administrator']['email'] ?>" class="input" />
		</div>

		<input name="data[Administrator][avatar]" type="hidden" id="YourAvatar" />
		<input name="data[Photo][json]" type="hidden" value="true" />
		<input name="data[Photo][id]" type="hidden" value="<?= !empty($administrator['Photo']['id']) ? $administrator['Photo']['id'] : 0 ?>" />
		<input style="display:none" type="file" id="PhotoNewFile" class="new-upload" name="data[<?= Upload::POST_PLACEHOLDER ?>]">
		<input name="data[Administrator][token]" type="hidden" id="ProfileImageToken" />

		<div class="clear"></div>
		<div class="options">
			<a class="btn btn-default close-form" href="javascript:void(0)"><?= __('Cancel') ?></a>
			<button type="submit" class="btn btn-success"><?= __('Save Changes') ?></button>
			<img src="/img/ico/loader_small.gif" class="loader" />
		</div>
	</form>
</div>

<?php if (sizeof($languages = Configure::read('Config.Languages')) > 1) { ?>
	<div class="language-list">
		<h4><?= __('Select your language') ?></h4>
		<ul>
			<?php foreach ($languages as $abbr => $language) { ?>
				<li>
					<?=
					$this->Html->link(
						(!empty($language['Icon']['file']) ? $this->Html->image($language['Icon']['file']) : null) . $language['Language']['title'],
						"/{$abbr}/" . substr($this->request->here, 2 + strlen($abbr)),
						[ 'class' => $abbr == $locale ? 'btn btn-default selected' : 'btn btn-default' ]
					)
					?>
				</li>
			<?php } ?>
		</ul>
	</div>
<?php } ?>

<script type="text/javascript">

	// Polyglot
	Polyglot.sideProfile = {
		error_file_unsupported: '<?= __('Please supply an image (jpeg, png or gif)') ?>',
		error_files_uploading: '<?= __('Please wait, there are files uploading right now') ?>',
		error_files_upload: '<?= __('An error has occurred') ?>'
	}

</script>

<?= $this->Html->script('layouts/elements/profile') ?>
