<?php

	if(!isset($index)) {
		$index = '!#!';
	}

	$options = [
		$this->Form->input('Module.Fields.' . $index . '.old', ['type' => 'hidden', 'value' => $this->Form->value('Fields.name')]),
		$this->Form->input('Module.Fields.' . $index . '.options.length', ['type' => 'number', 'label' => __('Maximum length'), 'div' => 'input input-half text type-varchar clearfix', 'default' => 200, 'adjust' => 'half']),
		$this->Form->input('Module.Fields.' . $index . '.options.bigint', ['type' => 'checkbox', 'label' => __('Big integer'), 'div' => 'input input-half text type-int clearfix', 'adjust' => 'checkbox', 'side' => true]),
		$this->Form->input('Module.Fields.' . $index . '.options.checked', ['type' => 'checkbox', 'label' => __('Checked by default'), 'div' => 'input input-half text type-tinyint clearfix', 'adjust' => 'checkbox', 'side' => true]),
		$this->Form->input('Module.Fields.' . $index . '.options.richtext', ['type' => 'checkbox', 'label' => __('Use rich-text editor'), 'div' => 'input input-half text type-text clearfix', 'default' => true, 'adjust' => 'checkbox', 'side' => true]),
		$this->Form->input('Module.Fields.' . $index . '.options.extensions', [
			'type' => 'text',
			'label' => __('Allowed extensions'),
			'div' => 'input input-half text type-file clearfix',
			'between' => '<div class="file-extension">'. $this->Form->select('Module.Fields.' . $index . '.helper.extensions', $uploadTypes, null, $uploadOptions),
			'after' => '</div>',
		]),
		$this->Form->input('Module.Fields.' . $index . '.options.comment', ['type' => 'text', 'label' => __('Comment'), 'div' => 'input input-half text type-file clearfix', 'adjust' => 'half']),
		$this->Form->input('Module.Fields.' . $index . '.options.multiple', ['type' => 'checkbox', 'label' => __('Multiple uploads'), 'div' => 'input input-half text type-file clearfix', 'adjust' => 'checkbox', 'side' => true]),
		$this->Form->input('Module.Fields.' . $index . '.options.justdate', ['type' => 'checkbox', 'label' => __('Include just date'), 'div' => 'input input-half text type-datetime clearfix', 'default' => false, 'adjust' => 'checkbox', 'side' => true]),
		$this->Form->input('Module.Fields.' . $index . '.options.list', ['type' => 'textarea', 'label' => __('Possible values'), 'div' => 'input input-half text type-enum clearfix', 'rte' => false, 'adjust' => 'full']),
		sizeof(Configure::read('Config.Languages')) > 1 ? $this->Form->input('Module.Fields.' . $index . '.options.polyglot', ['type' => 'checkbox', 'label' => __('Multilingual'), 'div' => 'input input-half text type-varchar type-text clearfix', 'default' => true]) : ''
	];

?>
<li class="ico-colored field" id="ModuleFields<?= $index ?>Holder">
	<?php

		# Get validations
		$moduleFieldRules = !empty($field['ModuleFieldRules'])
			? $field['ModuleFieldRules']
			: [];

		# Define field
		$field = $this->Form->input(
			'Module.Fields.' . $index . '.name',
			[
				'label' => false,
				'class' => 'field-name',
				'before' => '<i class="fa fa-fw fa-asterisk type"></i>',
				'after' => $this->Form->select('Module.Fields.' . $index . '.module_name', $modules, ['class' => 'field-module']),
				'div' => 'input text field-' . $index . '']
		);

		# Header options
		$fieldType = $this->Form->select('Module.Fields.' . $index . '.type', $fieldTypes, ['empty' => false, 'class' => 'field-type']);
		$removeField = $this->Html->link('<i class="fa fa-fw fa-trash-o"> </i>', '#', ['class' => 'remove-field', 'title' => __('Remove field'), 'onclick' => 'return ModuleManager.removeField(this)']);
		$isRequired = $this->Form->input('Module.Fields.' . $index . '.required', ['type' => 'checkbox', 'label' => __('Required'), 'div' => 'input checkbox side clearfix required', 'adjust' => 'checkbox', 'side' => true]);

		echo '<div class="field-header">';
			echo '<div class="row">';
				echo '<div class="col-md-3">';
					echo '<div class="input">' . $fieldType . '</div>';
				echo '</div>';
				echo '<div class="col-md-7">' . $removeField . $field . '</div>';
				echo '<div class="col-md-2">' .	 $isRequired .'</div>';
			echo '</div>';
		echo '</div>';

		# Options and validation
		echo '<div class="field-more">';
			echo '<div class="row">';
				echo '<div class="col-md-3">';
					echo '<div class="field-options">' . implode($options) . '</div>';
				echo '</div>';
				echo '<div class="col-md-9"><div class="field-validation">' . $this->element('modules/validation', compact('index', 'field', 'moduleFieldRules')) . '</div>';
			echo '</div>';
		echo '</div>';
	?>
</li>
