<?php

App::uses('FormHelper', 'View/Helper');

class ReportHelper extends AppHelper {

	public function drawChart($action, $icon, $title, $options, $params = []) {
		$default = [];

		# Get the default value
		foreach ($options as $i => $option) {
			$default[$i] = null;

			foreach ($option['values'] as $key => $value) {
				if ($option['default'] == $key) {
					$default[$i] = $key;
					break;
				}
			}
		}

		# Get the options
		$iconStyle = !empty($params['icon-style']) ? ' style="' . $params['icon-style'] . '"' : null;

		ob_start(); ?>
		<div id="Graph-<?= $action ?>" class="graph">
			<h2>
				<span><i class="fa fa-fw fa-<?= $icon ?>"<?= $iconStyle ?>></i><?= $title ?></span>

				<form action="<?= $action ?>">
					<?php foreach ($options as $i => $option) { ?>
						<select class="graph-options" <?= count($option['values']) > 1 ? 'block' : 'none' ?>">
						<?php foreach ($option['values'] as $key => $label) { ?>
							<option value="<?= $key ?>"<?= $default[$i] === $key ? ' selected="selected"' : null ?>><?= $label ?></option>
						<?php } ?>
						</select>
					<?php } ?>
				</form>
			</h2>

			<div style="height:245px;position:relative">
				<div class="page-loader" style="text-align:center; padding:100px 0; position:absolute; width: 100%">
					<img src="/img/ico/loader_medium.gif" alt="loader">
				</div>
				<div class="canvas" style="display:none; width: 100%; height: 230px; position:absolute; overflow:hidden;"></div>
			</div>
		</div>
		<?
		return ob_get_clean();
	}

	public function printChartScript() {
		ob_start() ?>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script>
			google.load("visualization", "1", {packages: ['corechart']});
			google.setOnLoadCallback(drawChart);

			function drawChart() {

				// Get all available charts
				var graphs = $('.graph');
				graphs.find('select').change(function () {
					updateChart($(this).closest('.graph'));
				});

				// Initial update
				graphs.each(function () {
					updateChart($(this));
				});

				return false;
			}

			// Update specific chart
			function updateChart(chart) {

				// Get the form with options
				var form = chart.find('form');
				var action = form.attr('action');

				// Get options for chart
				var options = [];
				form.find('select').each(function () {
					options.push($(this).val());
				});

				// Get analytics by AJAX
				$.get(
					"/reports/" + action + "/" + options.join('/'),
					function(response) {

						// Remove one day
						response.data.splice(response.data.length - 1, 1);

						// Parse data
						var colors = response.colors;
						var data = google.visualization.arrayToDataTable(response.data);

						// Build chart
						var options = {
							areaOpacity: 0.25,
							legend: {
								position:
								'none' },
							curveType: 'none',
							hAxis: { slantedText: false, maxAlternation: 1, textStyle: { color: '#606060', fontSize: 13 }, gridlines: { count: 2 } },
							vAxis: { textStyle: { color:'#606060', fontSize: 13 }, gridlines: { count: 8, color: '#e1e1e1' } },
							chartArea: { left: '3%', top:'10%', width:'96%', height:'80%' },
							colors: colors
						};

						// Hide preloader
						chart.find('.page-loader').fadeOut();
						chart.find('.canvas').fadeIn();
						chart.find('span').attr('title', response.title);

						// Create formatter
						var formatter = new google.visualization.DateFormat({
							formatType: 'short'
						});
						formatter.format(data, 1);

						// Draw
						var chartGraph = new google.visualization.AreaChart(chart.find('.canvas')[0]);
						try {
							chartGraph.clearChart();
						} catch(e) {}
						chartGraph.draw(data, options);
					}
				);
			}

			$(window).resize(function () {
				drawChart();
			});
		</script>
		<?php

		return ob_get_clean();
	}
}
