<?php

/**
 * @var bool  $passed True if all checks have been passed.
 * @var array $rules  The list of tests.
 */

?>
<div class="row">
	<div class="col-xs-8 col-xs-offset-2 col-sm-6 col-sm-offset-3 col-md-4 col-md-offset-4 col-xl-quarter">

		<div class="row">

			<div>
				<h2><?= __('Enable writing to directories') ?></h2>
				<hr />
			</div>

			<?php if (!$passed) { ?>
				<div>
					<div class="alert alert-danger"><?= __('Please make sure all of the following directories can be written by your web server.') ?></div>
				</div>
			<?php } ?>

			<div>
				<?php foreach ($rules as $name => $group) { ?>
					<h3><?= $name ?></h3>

					<ul class="install-checklist">
						<?php foreach ($group as $rule => $result) { ?>
							<li class="<?= $result ? 'passed' : 'failed' ?>">
								<?= $rule ?>
								<i class="<?= $result ? ON_FA_VALUE : OFF_FA_VALUE ?> pull-right"></i>
							</li>
						<?php } ?>
					</ul>
				<?php } ?>
			</div>

			<?php if ($passed) { ?>
				<div class="text-right">
					<br />
					<a href="<?= Router::url('/install/setup') ?>" class="btn btn-success"><?= __('Next step') ?>
						&nbsp;
						<i class="fa fa-arrow-right"></i>
					</a>
				</div>
			<?php } ?>

		</div>

	</div>
</div>
