-- --------------------------------------------------------
-- Sitename:                     <?= $config['sitename'] ?>
-- CMS type:                     <?= $config['type'] ?>
--
-- Languages:                    <?= implode(', ', $config['languages']) ?>
--
-- Database name:                <?= $config['database']['database'] ?>
--
-- Generated:                    <?= date('Y-m-d H:i:s') ?>
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table `acos`
DROP TABLE IF EXISTS `acos`;
CREATE TABLE IF NOT EXISTS `acos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `foreign_key` int(10) unsigned DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `lft` int(10) unsigned DEFAULT NULL,
  `rght` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_acos__acos` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `acos`
DELETE FROM `acos`;
/*!40000 ALTER TABLE `acos` DISABLE KEYS */;
INSERT INTO `acos` (`id`, `parent_id`, `model`, `foreign_key`, `alias`, `lft`, `rght`) VALUES
	(1, NULL, NULL, NULL, 'controllers', 1, 40),
	(2, 1, NULL, NULL, 'Pages', 2, 3),
	(3, 1, NULL, NULL, 'Layouts', 4, 5),
	(4, 1, NULL, NULL, 'Elements', 6, 7),
	(5, 1, NULL, NULL, 'Stylesheets', 8, 9),
	(6, 1, NULL, NULL, 'Javascripts', 10, 11),
	(7, 1, NULL, NULL, 'Configs', 12, 13),
	(8, 1, NULL, NULL, 'Languages', 14, 15),
	(9, 1, NULL, NULL, 'Administrators', 16, 17),
	(10, 1, NULL, NULL, 'Categories', 18, 19),
	(11, 1, NULL, NULL, 'Tools', 20, 21),
	(12, 1, NULL, NULL, 'Modules', 22, 23);
/*!40000 ALTER TABLE `acos` ENABLE KEYS */;

-- Dumping structure for table `administrators`
DROP TABLE IF EXISTS `administrators`;
CREATE TABLE IF NOT EXISTS `administrators` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `username` char(32) NOT NULL,
  `password` char(64) NOT NULL,
  `full_name` varchar(64) NOT NULL,
  `email` varchar(50) NOT NULL,
  `style` text NOT NULL,
  `customization` text NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `recovery_hash` varchar(64) DEFAULT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_administrators__groups` (`group_id`),
  CONSTRAINT `FK_administrators__groups` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `administrators`
DELETE FROM `administrators`;
/*!40000 ALTER TABLE `administrators` DISABLE KEYS */;
INSERT INTO `administrators` (`id`, `group_id`, `username`, `password`, `full_name`, `email`, `style`, `customization`, `is_active`, `recovery_hash`, `modified`, `modified_by`, `created`, `created_by`) VALUES
	(1, 1, 'admin', '', 'Intellex', 'support@intellex.rs', 'a:0:{}', 'a:0:{}', 1, NULL, Now(), 0, Now(), 0);
/*!40000 ALTER TABLE `administrators` ENABLE KEYS */;

-- Dumping structure for table `aros`
DROP TABLE IF EXISTS `aros`;
CREATE TABLE IF NOT EXISTS `aros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `foreign_key` int(10) unsigned DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `lft` int(10) unsigned DEFAULT NULL,
  `rght` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_aros__acos` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `aros`
DELETE FROM `aros`;
/*!40000 ALTER TABLE `aros` DISABLE KEYS */;
INSERT INTO `aros` (`id`, `parent_id`, `model`, `foreign_key`, `alias`, `lft`, `rght`) VALUES
	(1, NULL, 'Group', 1, NULL, 1, 4),
	(2, 1, 'Administrator', 1, NULL, 2, 3),
	(3, NULL, 'Group', 2, NULL, 5, 6);
/*!40000 ALTER TABLE `aros` ENABLE KEYS */;

-- Dumping structure for table `aros_acos`
DROP TABLE IF EXISTS `aros_acos`;
CREATE TABLE IF NOT EXISTS `aros_acos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `aro_id` bigint(20) unsigned NOT NULL,
  `aco_id` bigint(20) unsigned NOT NULL,
  `_read` varchar(2) NOT NULL DEFAULT '0',
  `_write` varchar(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ARO_ACO_KEY` (`aro_id`,`aco_id`),
  KEY `FK_aros_acos_acos` (`aco_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `aros_acos`
DELETE FROM `aros_acos`;
/*!40000 ALTER TABLE `aros_acos` DISABLE KEYS */;
INSERT INTO `aros_acos` (`id`, `aro_id`, `aco_id`, `_read`, `_write`) VALUES
	(1, 1, 1, '1', '1');
/*!40000 ALTER TABLE `aros_acos` ENABLE KEYS */;

-- Dumping structure for table `blocks`
DROP TABLE IF EXISTS `blocks`;
CREATE TABLE IF NOT EXISTS `blocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `blocks`
DELETE FROM `blocks`;
/*!40000 ALTER TABLE `blocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `blocks` ENABLE KEYS */;

-- Dumping structure for table `bookmarks`
DROP TABLE IF EXISTS `bookmarks`;
CREATE TABLE IF NOT EXISTS `bookmarks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `administrator_id` bigint(20) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `url` varchar(1000) NOT NULL,
  `ordering` int(11) unsigned NOT NULL,
  `owned_by` int(11) unsigned NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_bookmarks_administrators` (`administrator_id`),
  CONSTRAINT `FK_bookmarks_administrators` FOREIGN KEY (`administrator_id`) REFERENCES `administrators` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `bookmarks`
DELETE FROM `bookmarks`;
/*!40000 ALTER TABLE `bookmarks` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookmarks` ENABLE KEYS */;

-- ~ -- Dumping structure for procedure BuildAPIStats
-- ~ DROP PROCEDURE IF EXISTS `BuildAPIStats`;
-- ~ DELIMITER //
-- ~ CREATE PROCEDURE `BuildAPIStats`()
    -- ~ MODIFIES SQL DATA
-- ~ BEGIN

	-- ~ DECLARE EXIT HANDLER FOR SQLEXCEPTION
	-- ~ BEGIN
		-- ~ ROLLBACK;
	-- ~ END;

	-- ~ # Clear stats
	-- ~ DELETE FROM `stats_apis`;
	-- ~ ALTER TABLE `stats_apis` AUTO_INCREMENT = 1;

	-- ~ # Insert into stats
	-- ~ INSERT INTO `stats_apis` (`locale`, `platform`, `count`, `date`)
		-- ~ SELECT `locale`, `platform`, count(*), DATE(`created`) as `date`
		-- ~ FROM `log_api`
		-- ~ GROUP BY `locale`, `platform`, `date`;

-- ~ END//
-- ~ DELIMITER ;

-- Dumping structure for table `categories`
DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(32) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
<?= srl("  `title__{{locale}}` varchar(512) DEFAULT NULL,") ?>
<?= srl("  `desc__{{locale}}` text COMMENT 'plain',") ?>
  `counter` int(11) NOT NULL DEFAULT '0',
<?= srl("  `slug__{{locale}}` varchar(512) DEFAULT NULL,") ?>
  `lft` int(11) NOT NULL,
  `rght` int(11) NOT NULL,
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `categories`
DELETE FROM `categories`;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;

-- Dumping structure for table `comments`
DROP TABLE IF EXISTS `comments`;
CREATE TABLE IF NOT EXISTS `comments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `model` varchar(100) NOT NULL,
  `foreign_key` bigint(20) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `text` text,
  `lft` int(11) DEFAULT NULL,
  `rght` int(11) DEFAULT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created_by` bigint(20) DEFAULT NULL,
  `modified_by` bigint(20) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `comments`
DELETE FROM `comments`;
/*!40000 ALTER TABLE `comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `comments` ENABLE KEYS */;

-- Dumping structure for table `config`
DROP TABLE IF EXISTS `config`;
CREATE TABLE IF NOT EXISTS `config` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(100) NOT NULL,
  `subgroup` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` text NOT NULL,
  `description` varchar(300) NOT NULL,
  `type` enum('String','Number','Select','Textarea') NOT NULL,
  `options` text NOT NULL,
  `is_js` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_name` (`group`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table `config`
DELETE FROM `config`;
/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`id`, `group`, `subgroup`, `name`, `value`, `description`, `type`, `options`, `is_js`, `modified_by`, `modified`, `created_by`, `created`) VALUES
	(101, 'Backend', '', 'homepage', '/dashboard', 'Landing page for administrators', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(102, 'Backend', 'dashboard', 'dashboard', '1', 'Allow dashboard in backend', 'Select', 'a:2:{i:0;s:12:"No dashboard";i:1;s:14:"Show dashboard";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(103, 'Backend', 'dashboard', 'dashboard_stats_api', '1', 'API analytics options', 'Select', 'a:5:{i:0;s:29:"No API analytics on dashboard";i:1;s:40:"Show analytics, without grouping options";i:3;s:42:"Show analytics, allow grouping by language";i:5;s:42:"Show analytics, allow grouping by platform";i:7;s:60:"Show analytics, allow grouping by both language and platform";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(104, 'Backend', 'dashboard', 'dashboard_history', '12', 'How many items to show in latest events', 'Number', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(105, 'Backend', 'Google maps', 'map_key', 'AIzaSyAlIqxOowH4EvZl6JfM2JlXf3eKygYQUcY', 'The API key for the Google maps', 'String', '', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(106, 'Backend', 'Google maps', 'map_type', 'ROADMAP', 'The type of the map for the the dialog', 'Select', 'a:4:{s:7:"ROADMAP";s:7:"Roadmap";s:9:"SATELLITE";s:9:"Satellite";s:6:"HYBRID";s:6:"Hybrid";s:7:"TERRAIN";s:12:"Terrain only";}', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(107, 'Backend', 'Google maps', 'map_zoom', '13', 'The default zoom for the map dialog', 'Number', '', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(108, 'Backend', 'Google maps', 'map_latitude', '44.812653', 'The default lattitude of the map center', 'String', '', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(109, 'Backend', 'Google maps', 'map_longitude', '20.458088', 'The default longitude of the map center', 'String', '', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(151, 'Backend', 'login', 'provider_intellex', '1', 'Enable Intellex login', 'Select', 'a:2:{i:0;s:7:"Disable";i:1;s:21:"Enable Intellex login";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(152, 'Backend', 'login', 'provider_google_client_id', '', 'Client ID for the Google+ login', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(153, 'Backend', 'login', 'provider_google_client_secret', '', 'Secret for the Google+ login', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(154, 'Backend', 'api', 'pixabay_api_key', '6316849-782962b5b451c1754a12aa720', 'The API key for the Pixabay service', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-11-03 20:49:51'),
	(201, 'Website', '', 'title', 'Vector CMS', 'The title of the website', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(202, 'Website', '', 'enabled', '1', 'Enable the website', 'Select', 'a:2:{i:0;s:16:"No, just backend";i:1;s:31:"Yes, this is a complete website";} ', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(203, 'Website', '', 'separator', ' - ', 'Separator for the page title', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(204, 'Website', '', 'graph', ' ______          __           ___    ___                    \r\n/\\__  _\\        /\\ \\__       /\\_ \\  /\\_ \\                   \r\n\\/_/\\ \\/     ___\\ \\ ,_\\    __\\//\\ \\ \\//\\ \\      __   __  _  \r\n   \\ \\ \\   /\' _ `\\ \\ \\/  /\'__`\\\\ \\ \\  \\ \\ \\   /\'__`\\/\\ \\/\'\\ \r\n    \\_\\ \\__/\\ \\/\\ \\ \\ \\_/\\  __/ \\_\\ \\_ \\_\\ \\_/\\  __/\\/>  </ \r\n    /\\_____\\ \\_\\ \\_\\ \\__\\ \\____\\/\\____\\/\\____\\ \\____\\/\\_/\\_\\\r\n    \\/_____/\\/_/\\/_/\\/__/\\/____/\\/____/\\/____/\\/____/\\//\\/_/', 'Hidden HTML graph', 'Textarea', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(205, 'Website', 'analitics', 'google_analytics', '', 'The ID for the Google analytics', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(206, 'Website', 'analitics', 'google_api_table_id', '', 'The table id for this site on Google API console', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(207, 'Website', 'analitics', 'google_api_refresh_token', '', 'The refresh token for the Google API console', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(301, 'Feature', '', 'SEO', '0', 'Enable SEO options', 'Select', 'a:2:{i:0;s:24:"No, disable SEO features";i:1;s:29:"Yes, enable full SEO features";}\r\n', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(302, 'Feature', '', 'plugin_rte', 'TinyMCE', 'Plugin to use for rich text editing', 'Select', 'a:2:{s:6:"Innova";s:13:"Innova Studio";s:7:"TinyMCE";s:7:"TinyMCE";}', 1, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(303, 'Feature', '', 'export_allowed', '1', 'Should export be allowed', 'Select', 'a:2:{i:0;s:18:"No, disable export";i:1;s:18:"Yes, enable export";} ', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(304, 'Feature', '', 'advanced_caching', '0', 'Use advanced caching?', 'Select', 'a:2:{i:0;s:31:"No, do not use advanced caching";i:1;s:30:"Yes, activate advanced caching";} ', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(305, 'Feature', '', 'hide_default_language_prefix', '1', 'Hide default language prefix from url', 'Select', 'a:2:{i:0;s:35:"No, always show language in the URL";i:1;s:39:"Yes, hide default language from the URL";} ', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(306, 'Feature', '', 'save_buttons', '1', 'Where to show buttons on the forms', 'Select', 'a:2:{i:0;s:15:"Only below form";i:1;s:32:"Below the form and in the header";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(307, 'Feature', '', 'newsletter', '0', 'Show newsletter option', 'Select', 'a:2:{i:0;s:22:"Do not show newsletter";i:1;s:15:"Show newsletter";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(308, 'Feature', '', 'compress_assets', '0', 'Should static assets be compressed', 'Select', 'a:2:{i:0;s:32:"No, do not compress static files";i:1;s:26:"Yes, compress static files";}\r\n', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(309, 'Feature', '', 'upload_backup', '0', 'Should uploads be backed up', 'Select', 'a:2:{i:0;s:19:"Do not backup files";i:1;s:12:"Backup files";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(401, 'Push', 'android', 'gcm_secret', '', 'The secret for Google Cloud Messaging', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(402, 'Push', 'apple', 'apple_passphrase', '', 'The passphrase for Apple push certificate', 'String', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(403, 'Push', 'apple', 'apple_gateway', '0', 'Use sandbox or production push gateway', 'Select', 'a:2:{i:0;s:11:"Use sandbox";i:1;s:14:"Use production";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(404, 'Push', 'apple', 'apple_dev_certificate', '', 'The development certificate for Apple push service', 'Textarea', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(405, 'Push', 'apple', 'apple_production_certificate', '', 'The production certificate for Apple push service', 'Textarea', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(501, 'Security', '', 'password_length', '8', 'The minimal length of the password', 'Number', '', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25'),
	(601, 'Development', '', 'debug', '2', 'Debug level', 'Select', 'a:4:{i:0;s:10:"Production";i:1;s:11:"Development";i:2;s:9:"Debugging";i:3;s:14:"Full debugging";}', 0, 4, '2018-01-27 20:07:06', 1, '2017-05-26 12:10:25');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;

-- Dumping structure for table `contents`
DROP TABLE IF EXISTS `contents`;
CREATE TABLE IF NOT EXISTS `contents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(50) NOT NULL,
  `foreign_key` int(10) unsigned NOT NULL,
  `field` varchar(50) NOT NULL,
  `locale` varchar(50) NOT NULL,
  `template_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content` longtext NOT NULL,
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_content__live_templates` (`template_id`),
  KEY `FK_content` (`model`,`foreign_key`,`field`,`locale`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `contents`
DELETE FROM `contents`;
/*!40000 ALTER TABLE `contents` DISABLE KEYS */;
/*!40000 ALTER TABLE `contents` ENABLE KEYS */;

-- Dumping structure for table `cron_background_jobs`
DROP TABLE IF EXISTS `cron_background_jobs`;
CREATE TABLE IF NOT EXISTS `cron_background_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `handler` varchar(50) CHARACTER SET utf8 NOT NULL,
  `params` text CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `run_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `cron_background_jobs`
DELETE FROM `cron_background_jobs`;
/*!40000 ALTER TABLE `cron_background_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `cron_background_jobs` ENABLE KEYS */;

-- Dumping structure for table `cron_background_job_logs`
DROP TABLE IF EXISTS `cron_background_job_logs`;
CREATE TABLE IF NOT EXISTS `cron_background_job_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `background_job_id` bigint(20) unsigned NOT NULL,
  `hash` varchar(200) NOT NULL,
  `pid` varchar(100) NOT NULL,
  `started` datetime NOT NULL,
  `finished` datetime DEFAULT NULL,
  `handler` varchar(200) NOT NULL,
  `params` text,
  `log` longtext,
  `stderr` longtext,
  `stdout` longtext,
  `status` int(11) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `cron_background_job_logs`
DELETE FROM `cron_background_job_logs`;
/*!40000 ALTER TABLE `cron_background_job_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `cron_background_job_logs` ENABLE KEYS */;

-- Dumping structure for table `cron_jobs`
DROP TABLE IF EXISTS `cron_jobs`;
CREATE TABLE IF NOT EXISTS `cron_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `expression` varchar(200) NOT NULL,
  `common_settings` varchar(200) DEFAULT NULL,
  `minute` varchar(200) NOT NULL DEFAULT '*',
  `hour` varchar(200) NOT NULL DEFAULT '*',
  `day` varchar(200) NOT NULL DEFAULT '*',
  `month` varchar(200) NOT NULL DEFAULT '*',
  `weekday` varchar(200) NOT NULL DEFAULT '*',
  `year` varchar(200) NOT NULL DEFAULT '*',
  `handler` varchar(200) NOT NULL,
  `state` int(11) NOT NULL DEFAULT '1',
  `params` text,
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `cron_jobs`
DELETE FROM `cron_jobs`;
/*!40000 ALTER TABLE `cron_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `cron_jobs` ENABLE KEYS */;

-- Dumping structure for table `cron_job_logs`
DROP TABLE IF EXISTS `cron_job_logs`;
CREATE TABLE IF NOT EXISTS `cron_job_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cron_job_id` bigint(20) unsigned NOT NULL,
  `hash` varchar(200) NOT NULL,
  `pid` varchar(100) NOT NULL,
  `name` varchar(200) NOT NULL,
  `started` datetime NOT NULL,
  `finished` datetime DEFAULT NULL,
  `handler` varchar(200) NOT NULL,
  `params` text,
  `log` longtext,
  `status` int(11) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `cron_job_logs`
DELETE FROM `cron_job_logs`;
/*!40000 ALTER TABLE `cron_job_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `cron_job_logs` ENABLE KEYS */;

-- Dumping structure for table `dictionary`
DROP TABLE IF EXISTS `dictionary`;
CREATE TABLE IF NOT EXISTS `dictionary` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(1024) NOT NULL,
  `value` varchar(1024) NOT NULL,
  `locale` varchar(3) NOT NULL,
  `group` varchar(32) NOT NULL,
  `domain` varchar(32) NOT NULL DEFAULT 'default',
  `files` text NOT NULL,
  `is_archive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `dictionary`
DELETE FROM `dictionary`;
/*!40000 ALTER TABLE `dictionary` DISABLE KEYS */;
/*!40000 ALTER TABLE `dictionary` ENABLE KEYS */;

-- Dumping structure for table `groups`
DROP TABLE IF EXISTS `groups`;
CREATE TABLE IF NOT EXISTS `groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `desc` text NOT NULL COMMENT 'plain',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `groups`
DELETE FROM `groups`;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` (`id`, `name`, `desc`, `modified`, `modified_by`, `created`, `created_by`) VALUES
	(1, 'superadmin', 'Superadministrators', Now(), 0, Now(), 0),
	(2, 'admin', 'Adminstrators', Now(), 0, Now(), 0);
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;

-- Dumping structure for table `languages`
DROP TABLE IF EXISTS `languages`;
CREATE TABLE IF NOT EXISTS `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL,
  `locale` varchar(10) NOT NULL,
  `format` varchar(64) NOT NULL,
  `color` varchar(64) DEFAULT NULL,
  `ordering` int(11) unsigned NOT NULL,
  `is_default` tinyint(1) unsigned NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `languages`
DELETE FROM `languages`;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` (`id`, `title`, `locale`, `format`, `color`, `ordering`, `is_default`, `is_active`, `modified_by`, `modified`, `created_by`, `created`) VALUES
<?php foreach($config['languages'] as $i => $locale) { ?>
	(NULL, '<?= InstallAssist::getLanguageName($locale) ?>', '<?= $locale ?>', '<?= $locale ?>', 'da251e', <?= $i ?>, <?= !$i ? 1 : 0 ?>, 1, 1, Now(), 1, Now())<?= $i == sizeof($config['languages']) - 1 ? ';' : ',' ?>

<?php } ?>
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;

-- Dumping structure for table `live_elements`
DROP TABLE IF EXISTS `live_elements`;
CREATE TABLE IF NOT EXISTS `live_elements` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `body` longtext NOT NULL,
  `arguments` varchar(512) NOT NULL,
  `stylesheet_set` text NOT NULL,
  `javascript_set` text NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `live_elements`
DELETE FROM `live_elements`;
/*!40000 ALTER TABLE `live_elements` DISABLE KEYS */;
/*!40000 ALTER TABLE `live_elements` ENABLE KEYS */;

-- Dumping structure for table `live_javascripts`
DROP TABLE IF EXISTS `live_javascripts`;
CREATE TABLE IF NOT EXISTS `live_javascripts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `data` longtext NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `live_javascripts`
DELETE FROM `live_javascripts`;
/*!40000 ALTER TABLE `live_javascripts` DISABLE KEYS */;
/*!40000 ALTER TABLE `live_javascripts` ENABLE KEYS */;

-- Dumping structure for table `live_layouts`
DROP TABLE IF EXISTS `live_layouts`;
CREATE TABLE IF NOT EXISTS `live_layouts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `body` longtext NOT NULL,
  `stylesheet_set` text NOT NULL,
  `javascript_set` text NOT NULL,
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `slug` varchar(100) NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `live_layouts`
DELETE FROM `live_layouts`;
/*!40000 ALTER TABLE `live_layouts` DISABLE KEYS */;
INSERT INTO `live_layouts` (`id`, `name`, `body`, `stylesheet_set`, `javascript_set`, `is_default`, `slug`, `modified_by`, `modified`, `created_by`, `created`) VALUES
	(1, 'Default', '', '', '', 0, '', 0, Now(), 0, Now());
/*!40000 ALTER TABLE `live_layouts` ENABLE KEYS */;

-- Dumping structure for table `live_stylesheets`
DROP TABLE IF EXISTS `live_stylesheets`;
CREATE TABLE IF NOT EXISTS `live_stylesheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(512) NOT NULL,
  `data` longtext NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `live_stylesheets`
DELETE FROM `live_stylesheets`;
/*!40000 ALTER TABLE `live_stylesheets` DISABLE KEYS */;
/*!40000 ALTER TABLE `live_stylesheets` ENABLE KEYS */;

-- Dumping structure for table `live_templates`
DROP TABLE IF EXISTS `live_templates`;
CREATE TABLE IF NOT EXISTS `live_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` longtext NOT NULL,
  `body` longtext NOT NULL,
  `stylesheet_set` text NOT NULL,
  `javascript_set` text NOT NULL,
  `is_admin_only` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `lft` int(11) unsigned NOT NULL,
  `rght` int(11) unsigned NOT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `live_templates`
DELETE FROM `live_templates`;
/*!40000 ALTER TABLE `live_templates` DISABLE KEYS */;
INSERT INTO `live_templates` (`id`, `parent_id`, `name`, `description`, `body`, `stylesheet_set`, `javascript_set`, `is_admin_only`, `lft`, `rght`, `modified_by`, `modified`, `created_by`, `created`) VALUES
	(1, NULL, 'Custom', '', '<code cms="block" type="custom"></code>\n', '', '', 1, 0, 0, 0, Now(), 0, Now()),
	(2, NULL, 'Richtext', '', '<div class="rich-text"><code cms="block" type="richtext"></code></div>\n', '', '', 1, 0, 0, 0, Now(), 0, Now());
/*!40000 ALTER TABLE `live_templates` ENABLE KEYS */;

-- Dumping structure for table `log`
DROP TABLE IF EXISTS `log`;
CREATE TABLE IF NOT EXISTS `log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('insert','update','delete','upload') NOT NULL,
  `administrator_id` bigint(20) unsigned DEFAULT NULL,
  `model` varchar(50) NOT NULL,
  `foreign_key` bigint(20) unsigned NOT NULL,
  `comment` text,
  `is_module` tinyint(1) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_log_administrators` (`administrator_id`),
  CONSTRAINT `FK_log_administrators` FOREIGN KEY (`administrator_id`) REFERENCES `administrators` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `log`
DELETE FROM `log`;
/*!40000 ALTER TABLE `log` DISABLE KEYS */;
/*!40000 ALTER TABLE `log` ENABLE KEYS */;

-- Dumping structure for table `log_api`
DROP TABLE IF EXISTS `log_api`;
CREATE TABLE IF NOT EXISTS `log_api` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(10) DEFAULT NULL,
  `platform` varchar(10) DEFAULT NULL,
  `controller` varchar(200) DEFAULT NULL,
  `controller_action` varchar(200) DEFAULT NULL,
  `ip_address` varchar(200) DEFAULT NULL,
  `user_agent` varchar(200) DEFAULT NULL,
  `token` varchar(300) DEFAULT NULL,
  `timestamp` bigint(20) DEFAULT NULL,
  `exception` text,
  `post_data` text NOT NULL,
  `passed_data` text NOT NULL,
  `named_params` text NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `log_api`
DELETE FROM `log_api`;
/*!40000 ALTER TABLE `log_api` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_api` ENABLE KEYS */;

-- Dumping structure for table `log_details`
DROP TABLE IF EXISTS `log_details`;
CREATE TABLE IF NOT EXISTS `log_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `field` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `from` text,
  `to` text,
  `language` varchar(50) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_log_details_log` (`log_id`),
  CONSTRAINT `FK_log_details_log` FOREIGN KEY (`log_id`) REFERENCES `log` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `log_details`
DELETE FROM `log_details`;
/*!40000 ALTER TABLE `log_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_details` ENABLE KEYS */;

-- Dumping structure for table `modules`
DROP TABLE IF EXISTS `modules`;
CREATE TABLE IF NOT EXISTS `modules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_group_id` bigint(20) unsigned DEFAULT NULL,
  `page_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(64) NOT NULL,
  `menu_name` varchar(64) DEFAULT NULL,
  `menu_icon` varchar(64) DEFAULT NULL,
  `icon` varchar(32) DEFAULT NULL,
  `use_table` varchar(64) NOT NULL,
  `order` varchar(64) NOT NULL,
  `table_prefix` varchar(64) NOT NULL,
  `has_details` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_hardcoded` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_single_item` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `has_comments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `paginate` int(11) unsigned NOT NULL DEFAULT '30',
  `has_one` text NOT NULL,
  `has_many` text NOT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `module_group_id` (`module_group_id`),
  CONSTRAINT `FK_modules_module_groups` FOREIGN KEY (`module_group_id`) REFERENCES `module_groups` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `modules`
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table `module_fields`
DROP TABLE IF EXISTS `module_fields`;
CREATE TABLE IF NOT EXISTS `module_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` bigint(20) unsigned NOT NULL,
  `module_name` varchar(100) DEFAULT NULL,
  `field_name` varchar(100) NOT NULL,
  `field_type` varchar(100) NOT NULL,
  `field_help_text` text,
  `required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_module_fields_modules` (`module_id`),
  CONSTRAINT `FK_module_fields_modules` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `module_fields`
DELETE FROM `module_fields`;
/*!40000 ALTER TABLE `module_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_fields` ENABLE KEYS */;

-- Dumping structure for table `module_field_rules`
DROP TABLE IF EXISTS `module_field_rules`;
CREATE TABLE IF NOT EXISTS `module_field_rules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_field_id` bigint(20) unsigned NOT NULL,
  `rule_id` bigint(20) unsigned NOT NULL,
  `additional_data` text CHARACTER SET utf8,
  `validation_message` text CHARACTER SET utf8,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_module_field_rules_module_fields` (`module_field_id`),
  KEY `FK_module_field_rules_validation_rules` (`rule_id`),
  CONSTRAINT `FK_module_field_rules_module_fields` FOREIGN KEY (`module_field_id`) REFERENCES `module_fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_module_field_rules_validation_rules` FOREIGN KEY (`rule_id`) REFERENCES `validation_rules` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `module_field_rules`
DELETE FROM `module_field_rules`;
/*!40000 ALTER TABLE `module_field_rules` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_field_rules` ENABLE KEYS */;

-- Dumping structure for table `module_groups`
DROP TABLE IF EXISTS `module_groups`;
CREATE TABLE IF NOT EXISTS `module_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `ordering` bigint(200) NOT NULL,
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `module_groups`
DELETE FROM `module_groups`;
/*!40000 ALTER TABLE `module_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_groups` ENABLE KEYS */;

-- Dumping structure for table `module_relationships`
DROP TABLE IF EXISTS `module_relationships`;
CREATE TABLE IF NOT EXISTS `module_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `master_module` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `master_fk` bigint(20) NOT NULL,
  `slave_module` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `slave_fk` bigint(20) NOT NULL,
  `ordering` bigint(20) unsigned NOT NULL,
  `modified_by` bigint(20) NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_master_module_master_fk_slave_module_ordering` (`name`,`master_module`,`master_fk`,`slave_module`,`slave_fk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `module_relationships`
DELETE FROM `module_relationships`;
/*!40000 ALTER TABLE `module_relationships` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_relationships` ENABLE KEYS */;

-- Dumping structure for table `module_relationship_parameters`
DROP TABLE IF EXISTS `module_relationship_parameters`;
CREATE TABLE IF NOT EXISTS `module_relationship_parameters` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_relationship_id` bigint(20) unsigned NOT NULL,
  `key` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `modified_by` bigint(20) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_module_relationship_parameters_module_relationships` (`module_relationship_id`),
  CONSTRAINT `FK_module_relationship_parameters_module_relationships` FOREIGN KEY (`module_relationship_id`) REFERENCES `module_relationships` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `module_relationship_parameters`
DELETE FROM `module_relationship_parameters`;
/*!40000 ALTER TABLE `module_relationship_parameters` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_relationship_parameters` ENABLE KEYS */;

-- Dumping structure for table `pages`
DROP TABLE IF EXISTS `pages`;
CREATE TABLE IF NOT EXISTS `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('Page','Wrapper','Link','Module','Custom') NOT NULL DEFAULT 'Page',
  `parent_id` int(11) unsigned DEFAULT NULL,
  `layout_id` int(11) unsigned NOT NULL,
  `module_id` int(11) unsigned DEFAULT NULL,
  `change_frequency` enum('always','hourly','daily','weekly','monthly','yearly','never') NOT NULL DEFAULT 'monthly',
  `priority` enum('0.0','0.1','0.2','0.3','0.4','0.5 - default','0.6','0.7','0.8','0.9','1.0') NOT NULL DEFAULT '0.5 - default',
<?= srl("  `title__{{locale}}` varchar(200) NOT NULL,") ?>
<?= srl("  `title_short__{{locale}}` varchar(200) NOT NULL,") ?>
<?= srl("  `summary__{{locale}}` varchar(400) NOT NULL,") ?>
<?= srl("  `slug__{{locale}}` varchar(200) NOT NULL,") ?>
<?= srl("  `content__{{locale}}` longtext NOT NULL,") ?>
  `body_class` varchar(50) DEFAULT NULL,
  `meta` varchar(50) DEFAULT NULL,
<?= srl("  `meta_title__{{locale}}` varchar(200) DEFAULT NULL,") ?>
<?= srl("  `meta_keywords__{{locale}}` text COMMENT 'plain',") ?>
<?= srl("  `meta_description__{{locale}}` text COMMENT 'plain',") ?>
  `seo_metatags` text,
  `seo_generated_metatags` text,
  `seo_last_mod` datetime DEFAULT NULL,
  `head_end` text,
  `body_start` text,
  `body_end` text,
<?= srl("  `is_translated__{{locale}}` tinyint(1) unsigned NOT NULL DEFAULT '1',") ?>
  `stylesheet_set` text NOT NULL,
  `javascript_set` text NOT NULL,
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_category` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `url` varchar(200) DEFAULT NULL,
  `url_target` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) unsigned NOT NULL,
  `rght` int(11) unsigned NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_popup` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `pages`
DELETE FROM `pages`;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` (`id`, `type`, `parent_id`, `layout_id`, `module_id`, `change_frequency`, `priority`, <?= sr("`title__{{locale}}`, ") ?><?= sr("`title_short__{{locale}}`, ") ?><?= sr("`summary__{{locale}}`, ") ?><?= sr("`slug__{{locale}}`, ") ?><?= sr("`content__{{locale}}`, ") ?>`body_class`, `meta`, <?= sr("`meta_title__{{locale}}`, ") ?><?= sr("`meta_keywords__{{locale}}`, ") ?><?= sr("`meta_description__{{locale}}`, ") ?>`seo_metatags`, `seo_generated_metatags`, `seo_last_mod`, `head_end`, `body_start`, `body_end`, <?= sr("`is_translated__{{locale}}`, ") ?>`stylesheet_set`, `javascript_set`, `is_default`, `is_category`, `is_visible`, `url`, `url_target`, `lft`, `rght`, `is_active`, `is_popup`, `modified_by`, `modified`, `created_by`, `created`) VALUES
	(1, 'Page', NULL, 1, NULL, 'never', '0.0', <?= sr("'404', ") ?><?= sr("'404', ") ?><?= sr("'', ") ?><?= sr("'404', ") ?><?= sr("'', ") ?>NULL, NULL, <?= sr("NULL, ") ?><?= sr("NULL, ") ?><?= sr("NULL, ") ?>NULL, NULL, NULL, NULL, NULL, NULL, <?= sr("1, ") ?>'', '', 0, 1, 1, NULL, 0, 1, 4, 1, 0, 1, Now(), 1, Now()),
	(2, 'Wrapper', NULL, 1, NULL, 'monthly', '0.5 - default', <?= sr("'Main navigation', ") ?><?= sr("'Main navigation', ") ?><?= sr("'', ") ?><?= sr("'main-navigation', ") ?><?= sr("'', ") ?>NULL, 'Generic', <?= sr("NULL, ") ?><?= sr("NULL, ") ?><?= sr("NULL, ") ?>NULL, NULL, NULL, NULL, NULL, NULL, <?= sr("1, ") ?>'', '', 0, 1, 1, NULL, 0, 1, 4, 1, 0, 1, Now(), 1, Now()),
	(3, 'Page', 2, 1, NULL, 'weekly', '0.7', <?= sr("'Homepage', ") ?><?= sr("'Homepage', ") ?><?= sr("'', ") ?><?= sr("'homepage', ") ?><?= sr("'', ") ?>NULL, 'Generic', <?= sr("NULL, ") ?><?= sr("NULL, ") ?><?= sr("NULL, ") ?>NULL, NULL, NULL, NULL, NULL, NULL, <?= sr("1, ") ?>'', '', 1, 1, 1, NULL, 0, 2, 3, 1, 0, 1, Now(), 1, Now());
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_configuration`
DROP TABLE IF EXISTS `plugin_wd_configuration`;
CREATE TABLE IF NOT EXISTS `plugin_wd_configuration` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `base_url` varchar(100) COLLATE utf8_bin NOT NULL,
  `specification` varchar(500) COLLATE utf8_bin DEFAULT NULL,
  `info` text COLLATE utf8_bin NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- Dumping data for table `plugin_wd_configuration`
DELETE FROM `plugin_wd_configuration`;
/*!40000 ALTER TABLE `plugin_wd_configuration` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_configuration` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_environment`
DROP TABLE IF EXISTS `plugin_wd_environment`;
CREATE TABLE IF NOT EXISTS `plugin_wd_environment` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `value` varchar(1000) DEFAULT NULL,
  `description` text COMMENT 'plain',
  `ordering` int(10) unsigned NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `plugin_wd_environment`
DELETE FROM `plugin_wd_environment`;
/*!40000 ALTER TABLE `plugin_wd_environment` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_environment` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_functions`
DROP TABLE IF EXISTS `plugin_wd_functions`;
CREATE TABLE IF NOT EXISTS `plugin_wd_functions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `function_collection_id` bigint(20) unsigned DEFAULT NULL,
  `url` varchar(200) DEFAULT NULL,
  `http_method` enum('GET','POST','PUT','DELETE','HEAD') DEFAULT NULL,
  `enc_type` enum('form-data','x-www-form-urlencoded','raw') DEFAULT NULL,
  `body` text COMMENT 'plain',
  `description` text,
  `ordering` bigint(20) unsigned NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`),
  KEY `FK_plugin_wd_functions_plugin_wd_function_collections` (`function_collection_id`),
  CONSTRAINT `FK_plugin_wd_functions_plugin_wd_function_collections` FOREIGN KEY (`function_collection_id`) REFERENCES `plugin_wd_function_collections` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `plugin_wd_functions`
DELETE FROM `plugin_wd_functions`;
/*!40000 ALTER TABLE `plugin_wd_functions` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_functions` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_function_collections`
DROP TABLE IF EXISTS `plugin_wd_function_collections`;
CREATE TABLE IF NOT EXISTS `plugin_wd_function_collections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `ordering` bigint(20) unsigned NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `plugin_wd_function_collections`
DELETE FROM `plugin_wd_function_collections`;
/*!40000 ALTER TABLE `plugin_wd_function_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_function_collections` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_function_params`
DROP TABLE IF EXISTS `plugin_wd_function_params`;
CREATE TABLE IF NOT EXISTS `plugin_wd_function_params` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `function_id` bigint(20) unsigned DEFAULT NULL,
  `type` enum('boolean','int','string','text','enum') COLLATE utf8_bin NOT NULL DEFAULT 'string',
  `default` text COLLATE utf8_bin NOT NULL,
  `options` text COLLATE utf8_bin NOT NULL,
  `description` text COLLATE utf8_bin NOT NULL,
  `ordering` int(11) unsigned NOT NULL,
  `modified_by` int(11) NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_plugin_wd_function_params_plugin_wd_functions` (`function_id`),
  KEY `ordering` (`ordering`),
  CONSTRAINT `FK_plugin_wd_function_params_plugin_wd_functions` FOREIGN KEY (`function_id`) REFERENCES `plugin_wd_functions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- Dumping data for table `plugin_wd_function_params`
DELETE FROM `plugin_wd_function_params`;
/*!40000 ALTER TABLE `plugin_wd_function_params` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_function_params` ENABLE KEYS */;

-- Dumping structure for table `plugin_wd_header`
DROP TABLE IF EXISTS `plugin_wd_header`;
CREATE TABLE IF NOT EXISTS `plugin_wd_header` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `value` varchar(1000) DEFAULT NULL,
  `description` text,
  `ordering` int(10) unsigned NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `plugin_wd_header`
DELETE FROM `plugin_wd_header`;
/*!40000 ALTER TABLE `plugin_wd_header` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin_wd_header` ENABLE KEYS */;

-- Dumping structure for table `push_subscribers`
DROP TABLE IF EXISTS `push_subscribers`;
CREATE TABLE IF NOT EXISTS `push_subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('android','ios') DEFAULT NULL,
  `device_key` text NOT NULL,
  `registration_key` text NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `push_subscribers`
DELETE FROM `push_subscribers`;
/*!40000 ALTER TABLE `push_subscribers` DISABLE KEYS */;
/*!40000 ALTER TABLE `push_subscribers` ENABLE KEYS */;

-- Dumping structure for table `seo_configuration`
DROP TABLE IF EXISTS `seo_configuration`;
CREATE TABLE IF NOT EXISTS `seo_configuration` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
<?= srl("  `global_title_suffix__{{locale}}` varchar(200) DEFAULT NULL,") ?>
<?= srl("  `global_meta_title__{{locale}}` varchar(200) DEFAULT NULL,") ?>
<?= srl("  `global_meta_description__{{locale}}` varchar(200) COMMENT 'plain',") ?>
<?= srl("  `global_meta_keywords__{{locale}}` varchar(200) COMMENT 'plain',") ?>
  `head_end` text,
  `body_start` text,
  `body_end` text,
  `seo_metatags` text,
  `seo_generated_metatags` text,
<?= srl("  `is_translated__{{locale}}` tinyint(1) unsigned NOT NULL DEFAULT '1',") ?>
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `seo_configuration`
DELETE FROM `seo_configuration`;
/*!40000 ALTER TABLE `seo_configuration` DISABLE KEYS */;
INSERT INTO `seo_configuration` (`id`, <?= sr("`global_title_suffix__{{locale}}`, ") ?><?= sr("`global_meta_title__{{locale}}`, ") ?><?= sr("`global_meta_description__{{locale}}`, ") ?><?= sr("`global_meta_keywords__{{locale}}`, ") ?>`head_end`, `body_start`, `body_end`, `seo_metatags`, `seo_generated_metatags`, <?= sr("`is_translated__{{locale}}`, ") ?>`created`, `modified`) VALUES
	(1, <?= sr("NULL, ") ?><?= sr("NULL, ") ?><?= sr("NULL, ") ?><?= sr("NULL, ") ?>NULL, NULL, NULL, NULL, NULL, <?= sr("1, ") ?>Now(), Now());
/*!40000 ALTER TABLE `seo_configuration` ENABLE KEYS */;

-- Dumping structure for table `seo_meta_tags`
DROP TABLE IF EXISTS `seo_meta_tags`;
CREATE TABLE IF NOT EXISTS `seo_meta_tags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `namespace` varchar(50) DEFAULT NULL,
  `value_type` enum('text','select','textarea','color') DEFAULT 'text',
  `value_options` text,
  `inherits` bigint(20) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_main` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `template` text,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `seo_meta_tags`
DELETE FROM `seo_meta_tags`;
/*!40000 ALTER TABLE `seo_meta_tags` DISABLE KEYS */;
INSERT INTO `seo_meta_tags` (`id`, `type`, `name`, `namespace`, `value_type`, `value_options`, `inherits`, `is_visible`, `is_main`, `template`, `created`, `modified`) VALUES
	(1, 'meta', 'title', NULL, 'text', NULL, NULL, 0, 1, NULL, Now(), Now()),
	(2, 'meta', 'keywords', NULL, 'textarea', NULL, NULL, 0, 1, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(3, 'meta', 'description', NULL, 'textarea', NULL, NULL, 0, 1, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(4, 'meta', 'image', NULL, 'text', NULL, NULL, 0, 1, NULL, Now(), Now()),
	(5, 'meta', 'msappication-TileColor', NULL, 'text', NULL, NULL, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(7, 'meta', 'msapplication-TileImage', NULL, 'text', NULL, NULL, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(8, 'meta', 'app_id', 'fb', 'text', NULL, NULL, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(9, 'meta', 'type', 'og', 'text', NULL, NULL, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(10, 'meta', 'site_name', 'og', 'text', NULL, NULL, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(11, 'meta', 'url', 'og', 'text', NULL, NULL, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(12, 'meta', 'title', 'og', 'text', NULL, 1, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(13, 'meta', 'description', 'og', 'textarea', NULL, 3, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(14, 'meta', 'image', 'og', 'text', NULL, 4, 1, 0, '<meta property="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(15, 'meta', 'url', 'twitter', 'text', NULL, NULL, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(16, 'meta', 'card', 'twitter', 'text', NULL, NULL, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(17, 'meta', 'description', 'twitter', 'textarea', NULL, 3, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(18, 'meta', 'image', 'twitter', 'text', NULL, 4, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(19, 'meta', 'title', 'twitter', 'text', NULL, 1, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(20, 'meta', 'site', 'twitter', 'text', NULL, NULL, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(21, 'meta', 'image:src', 'twitter', 'text', NULL, 4, 1, 0, '<meta name="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(22, 'itemprop', 'author', NULL, 'text', NULL, NULL, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(23, 'itemprop', 'url', NULL, 'text', NULL, NULL, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(24, 'itemprop', 'image', NULL, 'text', NULL, 4, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(25, 'itemprop', 'dateModified', NULL, 'text', NULL, NULL, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(26, 'itemprop', 'datePublished', NULL, 'text', NULL, NULL, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(27, 'itemprop', 'name', NULL, 'text', NULL, 1, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(28, 'itemprop', 'headline', NULL, 'text', NULL, 1, 1, 0, '<meta itemprop="{{tagtitle}}" content="{{tagvalue}}"/>', Now(), Now()),
	(29, 'rel', 'dns-prefetch', NULL, 'text', NULL, NULL, 1, 0, '<link rel="{{tagtitle}}" href="{{tagvalue}}">', Now(), Now()),
	(30, 'rel', 'canonical', NULL, 'text', NULL, NULL, 1, 0, '<link rel="{{tagtitle}}" href="{{tagvalue}}">', Now(), Now()),
	(31, 'rel', 'shortlink', NULL, 'text', NULL, NULL, 1, 0, '<link rel="{{tagtitle}}" href="{{tagvalue}}">', Now(), Now());
/*!40000 ALTER TABLE `seo_meta_tags` ENABLE KEYS */;

-- Dumping structure for table `seo_redirections`
DROP TABLE IF EXISTS `seo_redirections`;
CREATE TABLE IF NOT EXISTS `seo_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `redirect_from` varchar(2000) NOT NULL,
  `redirect_to` varchar(2000) NOT NULL,
  `redirect_type` enum('301-Moved Permanently','302-Found','307-Temporary Redirect') NOT NULL DEFAULT '301-Moved Permanently',
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `seo_redirections`
DELETE FROM `seo_redirections`;
/*!40000 ALTER TABLE `seo_redirections` DISABLE KEYS */;
/*!40000 ALTER TABLE `seo_redirections` ENABLE KEYS */;

-- Dumping structure for table `seo_sitemap_items`
DROP TABLE IF EXISTS `seo_sitemap_items`;
CREATE TABLE IF NOT EXISTS `seo_sitemap_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `loc` varchar(4000) NOT NULL,
  `changefreq` varchar(20) NOT NULL,
  `priority` varchar(20) NOT NULL,
  `lastmod` varchar(50) NOT NULL,
  `modtime` int(11) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `seo_sitemap_items`
DELETE FROM `seo_sitemap_items`;
/*!40000 ALTER TABLE `seo_sitemap_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `seo_sitemap_items` ENABLE KEYS */;

-- Dumping structure for table `slug_logs`
DROP TABLE IF EXISTS `slug_logs`;
CREATE TABLE IF NOT EXISTS `slug_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('Page','Module') NOT NULL DEFAULT 'Page',
  `page_id` bigint(20) unsigned DEFAULT NULL,
  `parent_page_id` bigint(20) unsigned DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `foreign_key` bigint(20) unsigned DEFAULT NULL,
  `from_slug` varchar(500) DEFAULT NULL,
  `to_slug` varchar(500) DEFAULT NULL,
  `locale` varchar(10) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `slug_logs`
DELETE FROM `slug_logs`;
/*!40000 ALTER TABLE `slug_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `slug_logs` ENABLE KEYS */;

-- Dumping structure for table `stats_apis`
DROP TABLE IF EXISTS `stats_apis`;
CREATE TABLE IF NOT EXISTS `stats_apis` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `platform` varchar(10) CHARACTER SET utf8 DEFAULT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `created` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `locale` (`locale`),
  KEY `platform` (`platform`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `stats_apis`
DELETE FROM `stats_apis`;
/*!40000 ALTER TABLE `stats_apis` DISABLE KEYS */;
/*!40000 ALTER TABLE `stats_apis` ENABLE KEYS */;

-- Dumping structure for table `theme`
DROP TABLE IF EXISTS `theme`;
CREATE TABLE IF NOT EXISTS `theme` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `primary_color` varchar(50) DEFAULT NULL,
  `secondary_color` varchar(50) DEFAULT NULL,
  `modified_by` int(11) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `created_by` int(11) unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `theme`
DELETE FROM `theme`;
/*!40000 ALTER TABLE `theme` DISABLE KEYS */;
INSERT INTO `theme` (`id`, `primary_color`, `secondary_color`, `modified_by`, `modified`, `created_by`, `created`) VALUES
	(1, '#5cb85c', '#4cae4c', 1, Now(), 1, Now());
/*!40000 ALTER TABLE `theme` ENABLE KEYS */;

-- Dumping structure for table `tool_render_emails`
DROP TABLE IF EXISTS `tool_render_emails`;
CREATE TABLE IF NOT EXISTS `tool_render_emails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_bin NOT NULL,
  `expression` longtext COLLATE utf8_bin NOT NULL,
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- Dumping data for table `tool_render_emails`
DELETE FROM `tool_render_emails`;
/*!40000 ALTER TABLE `tool_render_emails` DISABLE KEYS */;
/*!40000 ALTER TABLE `tool_render_emails` ENABLE KEYS */;

-- Dumping structure for table `uploads`
DROP TABLE IF EXISTS `uploads`;
CREATE TABLE IF NOT EXISTS `uploads` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(8) DEFAULT NULL,
  `association` varchar(32) NOT NULL,
  `model` varchar(32) NOT NULL,
  `foreign_key` int(11) unsigned NOT NULL,
  `filename` varchar(256) NOT NULL,
  `path` varchar(500) NOT NULL,
  `filesize` int(11) unsigned NOT NULL,
  `mimetype` varchar(64) NOT NULL,
  `title` varchar(100) NOT NULL,
  `meta` text,
  `ordering` int(11) unsigned DEFAULT NULL,
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `LINK` (`association`,`model`,`foreign_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `uploads`
DELETE FROM `uploads`;
/*!40000 ALTER TABLE `uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `uploads` ENABLE KEYS */;

-- Dumping structure for table `validation_rules`
DROP TABLE IF EXISTS `validation_rules`;
CREATE TABLE IF NOT EXISTS `validation_rules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 NOT NULL,
  `rule` varchar(100) CHARACTER SET utf8 NOT NULL,
  `additional_params` text CHARACTER SET utf8,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table `validation_rules`
DELETE FROM `validation_rules`;
/*!40000 ALTER TABLE `validation_rules` DISABLE KEYS */;
INSERT INTO `validation_rules` (`id`, `name`, `rule`, `additional_params`, `created`, `modified`) VALUES
	(1, 'Not empty', 'notBlank', 'a:0:{}', Now(), Now()),
	(2, 'AlphaNumeric', 'alphaNumeric', 'a:0:{}', Now(), Now()),
	(3, 'Numeric', 'numeric', 'a:0:{}', Now(), Now()),
	(4, 'Decimal', 'decimal', 'a:0:{}', Now(), Now()),
	(5, 'NaturalNumber', 'naturalNumber', 'a:0:{}', Now(), Now()),
	(6, 'Date', 'date', 'a:1:{i:0;s:6:"format";}', Now(), Now()),
	(7, 'Datetime', 'datetime', 'a:1:{i:0;s:6:"format";}', Now(), Now()),
	(8, 'Time', 'time', 'a:1:{i:0;s:6:"format";}', Now(), Now()),
	(9, 'Email', 'email', 'a:0:{}', Now(), Now()),
	(10, 'Min Length', 'minLength', 'a:1:{i:0;s:6:"length";}', Now(), Now()),
	(11, 'Max Length', 'maxLength', 'a:1:{i:0;s:6:"length";}', Now(), Now()),
	(12, 'Url', 'url', 'a:0:{}', Now(), Now()),
	(13, 'Custom', 'custom', 'a:1:{i:0;s:5:"regex";}', Now(), Now());
/*!40000 ALTER TABLE `validation_rules` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
